/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RecyclerAdapterHelper<T>
extends RecyclerView.Adapter<ViewHolder> {
    private List<T> list;
    private final int defaultLayout;
    private final int brId;

    public RecyclerAdapterHelper(List<T> list, int defaultLayout, int brId) {
        this.list = list;
        this.defaultLayout = defaultLayout;
        this.brId = brId;
    }

    public int getItemLayout() {
        return this.defaultLayout;
    }

    public int getItemViewType(int position) {
        return this.getItemLayout();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)viewType, (ViewGroup)parent, (boolean)false);
        return new ViewHolder(binding);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.binding.setVariable(this.brId, this.list.get(position));
        holder.binding.executePendingBindings();
    }

    public int getItemCount() {
        return this.list == null ? 0 : this.list.size();
    }

    public void addItem(int position, T item) {
        this.list.add(position, item);
        this.notifyItemChanged(position);
    }

    public void addItem(T item) {
        this.list.add(item);
        this.notifyItemChanged(this.list.size() - 1);
    }

    public void changeItem(int position, T item) {
        this.list.set(position, item);
        this.notifyItemChanged(position);
    }

    public void changeItem(T item) {
        int pos = this.list.indexOf(item);
        this.list.set(pos, item);
        this.notifyItemChanged(pos);
    }

    public void removeItem(int position) {
        this.list.remove(position);
        this.notifyItemRemoved(position);
    }

    public void removeItem(T item) {
        int pos = this.list.indexOf(item);
        this.list.remove(pos);
        this.notifyItemRemoved(pos);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void changeAllItem(List<T> itemData) {
        this.list = itemData;
        this.notifyDataSetChanged();
    }

    public void changeRangeItem(List<T> itemData, int positionStart, int itemCount) {
        this.list = itemData;
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    public void insertRangeItem(List<T> itemData, int positionStart, int itemCount) {
        this.list = itemData;
        this.notifyItemRangeInserted(positionStart, itemCount);
    }

    public void removeRangeItem(List<T> itemData, int positionStart, int itemCount) {
        this.list = itemData;
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ViewDataBinding binding;

        ViewHolder(ViewDataBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }
    }
}

