/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.helper;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.util.Pools;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.viewpager.widget.PagerAdapter;
import java.util.List;

public class PagerAdapterHelper<T>
extends PagerAdapter {
    private List<T> list;
    private final int defaultLayout;
    private final int brId;
    private final Pools.Pool<View> pool = new Pools.SimplePool(4);

    public PagerAdapterHelper(List<T> list, int defaultLayout, int brId) {
        this.list = list;
        this.defaultLayout = defaultLayout;
        this.brId = brId;
    }

    public int getCount() {
        return this.list == null ? 0 : this.list.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View view = (View)this.pool.acquire();
        if (view == null) {
            view = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)container.getContext()), (int)this.defaultLayout, (ViewGroup)container, (boolean)false).getRoot();
        }
        ViewDataBinding bind = DataBindingUtil.bind((View)view);
        assert (bind != null);
        bind.setVariable(this.brId, this.list.get(position));
        container.addView(view);
        return view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        View view = (View)object;
        container.removeView(view);
        this.pool.release((Object)view);
    }

    public void addItem(int position, T item) {
        this.list.add(position, item);
        this.notifyDataSetChanged();
    }

    public void addItem(T item) {
        this.list.add(item);
        this.notifyDataSetChanged();
    }

    public void changeItem(int position, T item) {
        this.list.set(position, item);
        this.notifyDataSetChanged();
    }

    public void changeItem(T item) {
        int pos = this.list.indexOf(item);
        this.list.set(pos, item);
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.list.remove(position);
        this.notifyDataSetChanged();
    }

    public void removeItem(T item) {
        this.list.remove(item);
        this.notifyDataSetChanged();
    }

    public void changeAllItem(List<T> itemData) {
        this.list = itemData;
        this.notifyDataSetChanged();
    }
}

