/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.mojang.math;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import top.hendrixshen.magiclib.impl.compat.mojang.math.Matrix4fCompatImpl;
import top.hendrixshen.magiclib.util.collect.Provider;

@Environment(value=EnvType.CLIENT)
public interface Matrix4fCompat
extends Provider<Matrix4f> {
    @NotNull
    public static Matrix4fCompat of(@NotNull Matrix4f matrix4f) {
        return new Matrix4fCompatImpl(matrix4f);
    }

    @NotNull
    public static Matrix4fCompat createScaleMatrix(float x, float y, float z) {
        return Matrix4fCompat.of(new Matrix4f().scale(x, y, z));
    }

    @NotNull
    public static Matrix4fCompat createTranslateMatrix(float x, float y, float z) {
        return Matrix4fCompat.of(new Matrix4f().translation(x, y, z));
    }

    public void setIdentity();

    public void multiplyWithTranslation(float var1, float var2, float var3);

    public void multiply(Matrix4f var1);

    public void multiply(Quaternionf var1);

    public Matrix4fCompat copy();
}

