/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import top.hendrixshen.magiclib.api.render.context.RenderContext;
import top.hendrixshen.magiclib.impl.render.CameraPositionTransformer;
import top.hendrixshen.magiclib.impl.render.context.RenderGlobal;
import top.hendrixshen.magiclib.util.minecraft.PositionUtil;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;
import top.hendrixshen.magiclib.util.minecraft.render.TextRenderUtil;

public class TextRenderer {
    public static final double DEFAULT_FONT_SCALE = 0.025;
    private final List<TextHolder> lines = Lists.newArrayList();
    private class_243 pos;
    private double shiftX = 0.0;
    private double shiftY = 0.0;
    private double fontScale = 0.025;
    private double lineHeightRatio = 1.0 * (double)RenderUtil.TEXT_LINE_HEIGHT / (double)RenderUtil.TEXT_HEIGHT;
    private int color = -1;
    private int backgroundColor = 0;
    private boolean shadow = false;
    private boolean seeThrough = false;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.DEFAULT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.DEFAULT;

    @NotNull
    public static TextRenderer create() {
        return new TextRenderer();
    }

    private TextRenderer() {
    }

    public void render() {
        double maxTextWidth;
        if (this.lines.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        RenderContext context = RenderContext.of(RenderSystem.getModelViewStack());
        CameraPositionTransformer positionTransformer = CameraPositionTransformer.create(this.pos);
        positionTransformer.apply(context);
        context.scale(-this.fontScale, -this.fontScale, this.fontScale);
        if (this.seeThrough) {
            RenderGlobal.disableDepthTest();
        } else {
            RenderGlobal.enableDepthTest();
        }
        RenderGlobal.depthMask(true);
        int lineNum = this.lines.size();
        double totalTextWidth = maxTextWidth = (double)this.lines.stream().mapToInt(TextHolder::getWidth).max().orElse(0);
        double totalTextHeight = (double)(RenderUtil.TEXT_HEIGHT * lineNum) + (this.lineHeightRatio - 1.0) * (double)(lineNum - 1);
        context.translate(this.horizontalAlignment.getTranslateX(totalTextWidth), this.verticalAlignment.getTranslateY(totalTextHeight), 0.0);
        context.translate(this.shiftX, this.shiftY, 0.0);
        RenderSystem.applyModelViewMatrix();
        RenderGlobal.enableBlend();
        RenderGlobal.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        block0: for (int i = 0; i < lineNum; ++i) {
            TextHolder holder = this.lines.get(i);
            float textX = (float)this.horizontalAlignment.getTextX(maxTextWidth, holder.getWidth());
            float textY = (float)(this.getLineHeight() * (double)i);
            int backgroundColor = this.backgroundColor;
            while (true) {
                class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                Matrix4f matrix4f = class_4590.method_22931().method_22936();
                mc.field_1772.method_22942(holder.text, textX, textY, this.color, this.shadow, matrix4f, (class_4597)immediate, this.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, backgroundColor, 0xF000F0);
                immediate.method_22993();
                if (backgroundColor == 0) continue block0;
                backgroundColor = 0;
            }
        }
        positionTransformer.restore();
        RenderSystem.applyModelViewMatrix();
    }

    private TextRenderer addLines(TextHolder ... lines) {
        Collections.addAll(this.lines, lines);
        return this;
    }

    private TextRenderer setLines(TextHolder ... lines) {
        this.lines.clear();
        this.addLines(lines);
        return this;
    }

    public TextRenderer text(class_5481 text) {
        return this.setLines(TextHolder.of(text));
    }

    public TextRenderer text(String text) {
        return this.setLines(TextHolder.of(text));
    }

    public TextRenderer text(class_2561 text) {
        return this.setLines(TextHolder.of(text));
    }

    public TextRenderer addLine(class_5481 text) {
        return this.addLines(TextHolder.of(text));
    }

    public TextRenderer addLine(String text) {
        return this.addLines(TextHolder.of(text));
    }

    public TextRenderer addLine(class_2561 text) {
        return this.addLines(TextHolder.of(text));
    }

    public TextRenderer lineHeightRatio(double lineHeightRatio) {
        this.lineHeightRatio = lineHeightRatio;
        return this;
    }

    public TextRenderer at(class_243 vec3) {
        this.pos = vec3;
        return this;
    }

    public TextRenderer at(double x, double y, double z) {
        return this.at(new class_243(x, y, z));
    }

    public TextRenderer atCenter(class_2338 blockPos) {
        return this.at(PositionUtil.centerOf(blockPos));
    }

    public TextRenderer shift(double x, double y) {
        this.shiftX = x;
        this.shiftY = y;
        return this;
    }

    public TextRenderer fontScale(double fontScale) {
        this.fontScale = fontScale;
        return this;
    }

    public TextRenderer color(int color) {
        this.color = color;
        return this;
    }

    public TextRenderer bgColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public TextRenderer color(int color, int backgroundColor) {
        this.color(color);
        this.bgColor(backgroundColor);
        return this;
    }

    public TextRenderer shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public TextRenderer shadow() {
        return this.shadow(true);
    }

    public TextRenderer seeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        return this;
    }

    public TextRenderer seeThrough() {
        return this.seeThrough(true);
    }

    public TextRenderer align(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public TextRenderer align(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public double getLineHeight() {
        return (double)RenderUtil.TEXT_HEIGHT * this.lineHeightRatio;
    }

    @Generated
    public class_243 getPos() {
        return this.pos;
    }

    public static enum HorizontalAlignment {
        LEFT(w -> 0.0, (w, tw) -> 0.0),
        RIGHT(w -> -w.doubleValue(), (w, tw) -> w - tw),
        CENTER(w -> -0.5 * w, (w, tw) -> 0.5 * (w - tw));

        public static final HorizontalAlignment DEFAULT;
        private final Function<Double, Double> trMapper;
        private final BiFunction<Double, Double, Double> posMapper;

        private HorizontalAlignment(Function<Double, Double> trMapper, BiFunction<Double, Double, Double> posMapper) {
            this.trMapper = trMapper;
            this.posMapper = posMapper;
        }

        public double getTranslateX(double width) {
            return this.trMapper.apply(width);
        }

        public double getTextX(double width, double textWidth) {
            return this.posMapper.apply(width, textWidth);
        }

        static {
            DEFAULT = CENTER;
        }
    }

    public static enum VerticalAlignment {
        TOP(h -> 0.0),
        BOTTOM(h -> -h.doubleValue()),
        CENTER(h -> -0.5 * h);

        private final Function<Double, Double> trMapper;
        public static final VerticalAlignment DEFAULT;

        private VerticalAlignment(Function<Double, Double> trMapper) {
            this.trMapper = trMapper;
        }

        public double getTranslateY(double height) {
            return this.trMapper.apply(height);
        }

        static {
            DEFAULT = CENTER;
        }
    }

    private static class TextHolder {
        public final class_5481 text;

        private TextHolder(class_5481 text) {
            this.text = text;
        }

        @NotNull
        public static TextHolder of(class_5481 text) {
            return new TextHolder(text);
        }

        @Contract(value="_ -> new")
        @NotNull
        public static TextHolder of(String text) {
            return TextHolder.of(TextRenderUtil.string2formattedCharSequence(text));
        }

        @NotNull
        public static TextHolder of(@NotNull class_2561 text) {
            return new TextHolder(text.method_30937());
        }

        public int getWidth() {
            return RenderUtil.getRenderWidth(this.text);
        }
    }
}

