/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.minecraft.translation;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.fake.i18n.ServerPlayerLanguage;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.i18n.minecraft.translation.HookTranslationManager;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.StyleAccessor;
import top.hendrixshen.magiclib.util.minecraft.ComponentUtil;

public class MagicTranslation {
    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text) {
        return MagicTranslation.translate(text, I18n.getCurrentLanguageCode());
    }

    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text, String lang) {
        return MagicTranslation.translateComponent(text, lang);
    }

    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text, class_3222 player) {
        return MagicTranslation.translate(text, ((ServerPlayerLanguage)player).magicLib$getLanguage());
    }

    @NotNull
    private static MutableComponentCompat translateComponent(@NotNull MutableComponentCompat text, @NotNull String lang) {
        return MutableComponentCompat.of(MagicTranslation.translateComponent(text.get(), lang));
    }

    private static class_5250 translateComponent(class_5250 text, @NotNull String lang) {
        boolean[] translationRequired = new boolean[]{false};
        MagicTranslation.forEachTranslationComponent(text, lang, (txt, msgKeyString) -> {
            translationRequired[0] = true;
            return txt;
        });
        if (!translationRequired[0]) {
            return text;
        }
        return MagicTranslation.forEachTranslationComponent(ComponentUtil.copy(text), lang, (txt, msgKeyString) -> {
            class_5250 newText;
            class_2588 content = (class_2588)txt.method_10851();
            String txtKey = content.method_11022();
            Object[] txtArgs = content.method_11023();
            if (msgKeyString == null) {
                MagicLib.getLogger().warn("MagicTranslation: Unknown translation key {}", (Object)txtKey);
                return txt;
            }
            try {
                newText = ComponentUtil.format(msgKeyString, txtArgs).get();
            }
            catch (IllegalArgumentException e) {
                newText = ComponentUtil.simple(msgKeyString).get();
            }
            newText.method_10855().addAll(txt.method_10855());
            newText.method_10862(txt.method_10866());
            return newText;
        });
    }

    @NotNull
    private static class_5250 forEachTranslationComponent(class_5250 text, @NotNull String lang, ComponentModifier modifier) {
        class_2568 hoverEvent;
        class_5250 newText;
        int i;
        if (ComponentUtil.getTextContent(text) instanceof class_2588) {
            class_2588 translatableText = (class_2588)ComponentUtil.getTextContent(text);
            Object[] args = translatableText.method_11023();
            for (i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof class_5250) || (newText = MagicTranslation.forEachTranslationComponent((class_5250)arg, lang, modifier)) == arg) continue;
                args[i] = newText;
            }
            if (HookTranslationManager.getInstance().isNamespaceRegistered(translatableText.method_11022())) {
                String msgKeyString = I18n.trByCode((String)lang, (String)translatableText.method_11022());
                text = modifier.apply(text, msgKeyString);
            }
        }
        if ((hoverEvent = ((StyleAccessor)text.method_10866()).getHoverEvent()) != null) {
            class_5250 newText2;
            Object hoverText = hoverEvent.method_10891(hoverEvent.method_10892());
            if (hoverEvent.method_10892() == class_2568.class_5247.field_24342 && hoverText instanceof class_5250 && (newText2 = MagicTranslation.forEachTranslationComponent((class_5250)hoverText, lang, modifier)) != hoverText) {
                text.method_10862(text.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)newText2)));
            }
        }
        List siblings = text.method_10855();
        for (i = 0; i < siblings.size(); ++i) {
            class_2561 sibling = (class_2561)siblings.get(i);
            newText = MagicTranslation.forEachTranslationComponent((class_5250)sibling, lang, modifier);
            if (newText == sibling) continue;
            siblings.set(i, newText);
        }
        return text;
    }

    @FunctionalInterface
    private static interface ComponentModifier {
        public class_5250 apply(class_5250 var1, @Nullable String var2);
    }
}

