/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.minecraft;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.fake.i18n.PackAccessor;
import top.hendrixshen.magiclib.api.i18n.LanguageProvider;
import top.hendrixshen.magiclib.impl.i18n.provider.FileLanguageProvider;
import top.hendrixshen.magiclib.util.JsonUtil;

public class ResourceLanguageProvider
implements LanguageProvider {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, List<Path>> files = Maps.newConcurrentMap();

    public void init() {
        class_310.method_1551().method_1520().method_14444().stream().filter(pack -> pack.method_14463().startsWith("file")).map(class_3288::method_14458).filter(pack -> pack instanceof PackAccessor).map(pack -> ((PackAccessor)pack).magiclib$getFile().toPath()).forEach(this::updateFileList);
    }

    public void reload() {
        this.files.clear();
        this.init();
    }

    public void reload(String LanguageCode) {
        this.reload();
    }

    public void loadLanguage(String languageCode) {
    }

    public Map<String, String> getLanguage(String languageCode) {
        ConcurrentMap result = Maps.newConcurrentMap();
        this.files.getOrDefault(languageCode, Collections.emptyList()).forEach(file -> {
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                JsonUtil.loadStringMapFromJson((InputStream)inputStream, result::put);
                MagicLib.getLogger().debug("Loaded language file {}.", file);
            }
            catch (Exception e) {
                MagicLib.getLogger().error("Failed to load language file {}.", file, (Object)e);
            }
        });
        return result;
    }

    private void updateFileList(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileLanguageProvider.LanguageFileVisitor(path, this.files, true));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Generated
    private ResourceLanguageProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ResourceLanguageProvider getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ResourceLanguageProvider actualValue = new ResourceLanguageProvider();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ResourceLanguageProvider)($value == instance ? null : $value);
    }
}

