/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.minecraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ClickEventCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.HoverEventCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.StyleCompat;
import top.hendrixshen.magiclib.impl.compat.minecraft.world.level.dimension.DimensionWrapper;
import top.hendrixshen.magiclib.impl.i18n.minecraft.translation.Translator;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.TranslatableComponentAccessor;
import top.hendrixshen.magiclib.util.MiscUtil;
import top.hendrixshen.magiclib.util.minecraft.ResourceLocationUtil;
import top.hendrixshen.magiclib.util.minecraft.TextUtil;

public class ComponentUtil {
    private static final Translator translator = new Translator("magiclib.util.minecraft");
    private static final ImmutableMap<class_1767, Consumer<MutableComponentCompat>> DYE_COLOR_APPLIER = (ImmutableMap)class_156.method_656(() -> {
        HashMap map = Maps.newHashMap();
        map.put(class_1767.field_7952, class_124.field_1068);
        map.put(class_1767.field_7967, class_124.field_1080);
        map.put(class_1767.field_7944, class_124.field_1063);
        map.put(class_1767.field_7963, class_124.field_1074);
        map.put(class_1767.field_7964, class_124.field_1061);
        map.put(class_1767.field_7947, class_124.field_1054);
        map.put(class_1767.field_7961, class_124.field_1060);
        map.put(class_1767.field_7942, class_124.field_1077);
        map.put(class_1767.field_7955, class_124.field_1062);
        map.put(class_1767.field_7951, class_124.field_1075);
        map.put(class_1767.field_7966, class_124.field_1058);
        map.put(class_1767.field_7945, class_124.field_1064);
        map.put(class_1767.field_7958, class_124.field_1076);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        map.forEach((dyeColor, fmt) -> builder.put(dyeColor, text -> ComponentUtil.formatting(text, fmt)));
        Arrays.stream(class_1767.values()).filter(dyeColor -> !map.containsKey(dyeColor)).forEach(dyeColor -> builder.put(dyeColor, text -> text.setStyle(text.getStyle().withColor(class_5251.method_27717((int)dyeColor.method_16357())))));
        return builder.build();
    });
    private static final ImmutableMap<DimensionWrapper, MutableComponentCompat> DIMENSION_NAME = ImmutableMap.of((Object)DimensionWrapper.OVERWORLD, (Object)ComponentUtil.tr("flat_world_preset.minecraft.overworld", new Object[0]), (Object)DimensionWrapper.NETHER, (Object)ComponentUtil.tr("advancements.nether.root.title", new Object[0]), (Object)DimensionWrapper.THE_END, (Object)ComponentUtil.tr("advancements.end.root.title", new Object[0]));

    public static class_7417 getTextContent(@NotNull class_5250 text) {
        return text.method_10851();
    }

    @NotNull
    public static MutableComponentCompat compose(Object ... objects) {
        MutableComponentCompat literal = ComponentUtil.empty();
        for (Object o : objects) {
            if (o instanceof MutableComponentCompat) {
                literal.append((MutableComponentCompat)o);
                continue;
            }
            if (o instanceof class_5250) {
                literal.append(MutableComponentCompat.of((class_5250)MiscUtil.cast((Object)o)));
                continue;
            }
            literal.append(o.toString());
        }
        return literal;
    }

    @NotNull
    public static MutableComponentCompat simple(@NotNull Object text) {
        return ComponentCompat.literal(text.toString());
    }

    @NotNull
    public static MutableComponentCompat simple(Object text, class_124 ... chatFormattings) {
        return ComponentUtil.formatting(ComponentUtil.simple(text), chatFormattings);
    }

    @NotNull
    public static MutableComponentCompat empty() {
        return ComponentUtil.simple("");
    }

    @NotNull
    public static MutableComponentCompat newLine() {
        return ComponentUtil.simple("\n");
    }

    public static MutableComponentCompat colored(MutableComponentCompat text, class_1767 value) {
        Consumer consumer = (Consumer)DYE_COLOR_APPLIER.get((Object)value);
        if (consumer != null) {
            consumer.accept(text);
        }
        return text;
    }

    public static MutableComponentCompat colored(MutableComponentCompat text, Object value) {
        class_124 color = null;
        if (Boolean.TRUE.equals(value)) {
            color = class_124.field_1060;
        } else if (Boolean.FALSE.equals(value)) {
            color = class_124.field_1061;
        }
        if (value instanceof Number) {
            color = class_124.field_1065;
        }
        if (color != null) {
            ComponentUtil.formatting(text, color);
        }
        return text;
    }

    public static MutableComponentCompat colored(Object value) {
        return ComponentUtil.colored(ComponentUtil.simple(value), value);
    }

    public static MutableComponentCompat property(class_2769<?> property, Object value) {
        return ComponentUtil.colored(ComponentUtil.simple(TextUtil.property(property, value)), value);
    }

    @NotNull
    public static MutableComponentCompat tr(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof ComponentCompat)) continue;
            args[i] = ((ComponentCompat)args[i]).get();
        }
        return ComponentCompat.translatable(key, args);
    }

    @NotNull
    public static MutableComponentCompat fancy(MutableComponentCompat displayText, MutableComponentCompat hoverText, ClickEventCompat clickEvent) {
        MutableComponentCompat text = ComponentUtil.copy(displayText);
        if (hoverText != null) {
            ComponentUtil.hover(text, hoverText);
        }
        if (clickEvent != null) {
            ComponentUtil.click(text, clickEvent);
        }
        return text;
    }

    @NotNull
    public static MutableComponentCompat join(MutableComponentCompat joiner, @NotNull Iterable<ComponentCompat> items) {
        MutableComponentCompat text = ComponentUtil.empty();
        boolean first = true;
        for (ComponentCompat item : items) {
            if (!first) {
                text.append(joiner);
            }
            first = false;
            text.append(item);
        }
        return text;
    }

    @NotNull
    public static MutableComponentCompat join(MutableComponentCompat joiner, ComponentCompat ... items) {
        return ComponentUtil.join(joiner, Arrays.asList(items));
    }

    @NotNull
    public static MutableComponentCompat format(String formatter, Object ... args) {
        TranslatableComponentAccessor dummy = (TranslatableComponentAccessor)ComponentUtil.tr(formatter, args).get().method_10851();
        try {
            ArrayList segments = Lists.newArrayList();
            dummy.magiclib$invokeDecomposeTemplate(formatter, segments::add);
            return ComponentUtil.compose(segments.stream().map(formattedText -> {
                if (formattedText instanceof class_2561) {
                    return (class_2561)formattedText;
                }
                return ComponentUtil.simple(formattedText.getString());
            }).toArray());
        }
        catch (class_2590 e) {
            throw new IllegalArgumentException(formatter);
        }
    }

    @NotNull
    public static MutableComponentCompat bool(boolean bool) {
        return ComponentUtil.simple(String.valueOf(bool), bool ? class_124.field_1060 : class_124.field_1061);
    }

    private static MutableComponentCompat getTeleportHint(MutableComponentCompat dest) {
        return translator.tr("teleport_hint.hover", dest);
    }

    @NotNull
    private static MutableComponentCompat coordinate(@Nullable DimensionWrapper dim, String posStr, String command) {
        MutableComponentCompat hoverText = ComponentUtil.empty();
        hoverText.append(ComponentUtil.getTeleportHint(ComponentUtil.simple(posStr)));
        if (dim != null) {
            hoverText.append("\n");
            hoverText.append(translator.tr("teleport_hint.dimension", new Object[0]));
            hoverText.append(": ");
            hoverText.append(ComponentUtil.dimension(dim));
        }
        return ComponentUtil.fancy(ComponentUtil.simple(posStr), hoverText, ClickEventCompat.of(class_2558.class_2559.field_11745, command));
    }

    @NotNull
    public static MutableComponentCompat coordinate(class_243 pos, DimensionWrapper dim) {
        return ComponentUtil.coordinate(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static MutableComponentCompat coordinate(class_2382 pos, DimensionWrapper dim) {
        return ComponentUtil.coordinate(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static MutableComponentCompat coordinate(class_1923 pos, DimensionWrapper dim) {
        return ComponentUtil.coordinate(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static MutableComponentCompat coordinate(class_243 pos) {
        return ComponentUtil.coordinate(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static MutableComponentCompat coordinate(class_2382 pos) {
        return ComponentUtil.coordinate(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static MutableComponentCompat coordinate(class_1923 pos) {
        return ComponentUtil.coordinate(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    private static MutableComponentCompat vector(String displayText, String detailedText) {
        return ComponentUtil.fancy(ComponentUtil.simple(displayText), ComponentUtil.simple(detailedText), ClickEventCompat.of(class_2558.class_2559.field_11745, detailedText));
    }

    @NotNull
    public static MutableComponentCompat vector(class_243 vec) {
        return ComponentUtil.vector(TextUtil.vector(vec), TextUtil.vector(vec, 6));
    }

    @NotNull
    public static MutableComponentCompat entityType(@NotNull class_1299<?> entityType) {
        return MutableComponentCompat.of((class_5250)MiscUtil.cast((Object)entityType.method_5897()));
    }

    @NotNull
    public static MutableComponentCompat entityType(@NotNull class_1297 entity) {
        return ComponentUtil.entityType(entity.method_5864());
    }

    @NotNull
    public static MutableComponentCompat entity(class_1297 entity) {
        MutableComponentCompat entityBaseName = ComponentUtil.entityType(entity);
        MutableComponentCompat entityDisplayName = MutableComponentCompat.of((class_5250)MiscUtil.cast((Object)entity.method_5477()));
        MutableComponentCompat hoverText = ComponentUtil.compose(translator.tr("entity_type", entityBaseName, ComponentUtil.simple(class_1299.method_5890((class_1299)entity.method_5864()).toString())), ComponentUtil.newLine(), ComponentUtil.getTeleportHint(entityDisplayName));
        return ComponentUtil.fancy(entityDisplayName, hoverText, ClickEventCompat.of(class_2558.class_2559.field_11745, TextUtil.tp(entity)));
    }

    @NotNull
    public static MutableComponentCompat attribute(@NotNull class_1320 attribute) {
        return ComponentUtil.tr(attribute.method_26830(), new Object[0]);
    }

    public static MutableComponentCompat dimension(DimensionWrapper dim) {
        MutableComponentCompat dimText = (MutableComponentCompat)DIMENSION_NAME.get((Object)dim);
        return dimText != null ? ComponentUtil.copy(dimText) : ComponentUtil.simple(dim.getResourceLocationString());
    }

    @NotNull
    public static MutableComponentCompat getColoredDimensionSymbol(@NotNull DimensionWrapper dimensionType) {
        if (dimensionType.equals(DimensionWrapper.OVERWORLD)) {
            return ComponentUtil.simple("O", class_124.field_1077);
        }
        if (dimensionType.equals(DimensionWrapper.NETHER)) {
            return ComponentUtil.simple("N", class_124.field_1079);
        }
        if (dimensionType.equals(DimensionWrapper.THE_END)) {
            return ComponentUtil.simple("E", class_124.field_1064);
        }
        return ComponentUtil.simple(dimensionType.getResourceLocationString().toUpperCase().substring(0, 1));
    }

    @NotNull
    public static MutableComponentCompat block(@NotNull class_2248 block) {
        return ComponentUtil.hover(ComponentUtil.tr(block.method_9539(), new Object[0]), ComponentUtil.simple(TextUtil.block(block)));
    }

    @NotNull
    public static MutableComponentCompat block(@NotNull class_2680 blockState) {
        ArrayList hovers = Lists.newArrayList();
        hovers.add(ComponentUtil.simple(TextUtil.block(blockState.method_26204())));
        for (class_2769 property : blockState.method_28501()) {
            hovers.add(ComponentUtil.compose(ComponentUtil.simple(property.method_11899()), ComponentUtil.simple(" : ").withStyle(style -> style.withColor(class_124.field_1080)), ComponentUtil.property(property, blockState.method_11654(property))));
        }
        return ComponentUtil.fancy(ComponentUtil.block(blockState.method_26204()), ComponentUtil.join(ComponentUtil.newLine(), hovers.toArray(new MutableComponentCompat[0])), ClickEventCompat.of(class_2558.class_2559.field_11745, TextUtil.block(blockState)));
    }

    @NotNull
    public static MutableComponentCompat fluid(@NotNull class_3611 fluid) {
        return ComponentUtil.hover(ComponentUtil.block(fluid.method_15785().method_15759().method_26204()), ComponentUtil.simple(ResourceLocationUtil.id(fluid).toString()));
    }

    @NotNull
    public static MutableComponentCompat fluid(@NotNull class_3610 fluid) {
        return ComponentUtil.fluid(fluid.method_15772());
    }

    @NotNull
    public static MutableComponentCompat blockEntity(@NotNull class_2586 blockEntity) {
        class_2960 id = ResourceLocationUtil.id(blockEntity.method_11017());
        return ComponentUtil.simple(id != null ? id.toString() : blockEntity.getClass().getSimpleName());
    }

    @NotNull
    public static MutableComponentCompat item(@NotNull class_1792 item) {
        return ComponentUtil.tr(item.method_7876(), new Object[0]);
    }

    public static MutableComponentCompat color(@NotNull class_1767 color) {
        return translator.tr("color." + color.method_7792().toLowerCase(), new Object[0]);
    }

    @NotNull
    public static MutableComponentCompat hover(@NotNull MutableComponentCompat text, HoverEventCompat hoverEvent) {
        text.withStyle(style -> style.withHoverEvent(hoverEvent));
        return text;
    }

    @NotNull
    public static MutableComponentCompat hover(MutableComponentCompat text, MutableComponentCompat hoverText) {
        return ComponentUtil.hover(text, HoverEventCompat.of(class_2568.class_5247.field_24342, hoverText));
    }

    @NotNull
    public static MutableComponentCompat click(@NotNull MutableComponentCompat text, ClickEventCompat clickEvent) {
        text.withStyle(style -> style.withClickEvent(clickEvent));
        return text;
    }

    @NotNull
    public static MutableComponentCompat formatting(@NotNull MutableComponentCompat text, class_124 ... formattings) {
        text.withStyle(formattings);
        return text;
    }

    @NotNull
    public static MutableComponentCompat style(@NotNull MutableComponentCompat text, StyleCompat style) {
        text.setStyle(style);
        return text;
    }

    @NotNull
    public static MutableComponentCompat copy(@NotNull MutableComponentCompat text) {
        return MutableComponentCompat.of(ComponentUtil.copy(text.get()));
    }

    @NotNull
    public static class_5250 copy(@NotNull class_5250 text) {
        class_5250 copied = text.method_27661();
        if (ComponentUtil.getTextContent(copied) instanceof class_2588) {
            class_2588 translatableText = (class_2588)ComponentUtil.getTextContent(copied);
            Object[] args = (Object[])translatableText.method_11023().clone();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof class_5250)) continue;
                args[i] = ComponentUtil.copy((class_5250)args[i]);
            }
            ((TranslatableComponentAccessor)translatableText).magiclib$setArgs(args);
        }
        return copied;
    }
}

