/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.minecraft.translation;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import top.hendrixshen.magiclib.SharedConstants;

public class HookTranslationManager {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Set<String> namespaces = new HashSet<String>();

    public void registerNamespace(String namespace) {
        if (!SharedConstants.getValidLangNamespace().matcher(namespace).matches()) {
            throw new RuntimeException("Invalid namespace: " + namespace);
        }
        this.namespaces.add(namespace);
    }

    public @Unmodifiable ImmutableSet<String> getNamespaces() {
        return ImmutableSet.copyOf(this.namespaces);
    }

    public boolean isNamespaceRegistered(@NotNull String path) {
        return this.namespaces.stream().anyMatch(path::startsWith);
    }

    private HookTranslationManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HookTranslationManager getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    HookTranslationManager actualValue = new HookTranslationManager();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (HookTranslationManager)($value == instance ? null : $value);
    }
}

