/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import top.fullj.eventbus.EventExecutor;

class DelegateUiExecutor
implements EventExecutor {
    static final DelegateUiExecutor INSTANCE = new DelegateUiExecutor();
    private static final String CLS_ANDROID_HANDLER = "android.os.Handler";
    private static final String CLS_ANDROID_LOOPER = "android.os.Looper";
    private static final String CLS_AWT_EVENT_QUEUE = "java.awt.EventQueue";
    private final Executor executor = this.newExecutor();

    private DelegateUiExecutor() {
    }

    private Executor newExecutor() {
        if (this.isAndroid()) {
            return new AndroidExecutor();
        }
        if (this.isAwt()) {
            return new AwtExecutor();
        }
        return new BadExecutor();
    }

    @Override
    public String threadMode() {
        return "ui";
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    private boolean isAndroid() {
        try {
            Class.forName(CLS_ANDROID_HANDLER);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isAwt() {
        try {
            Class.forName(CLS_AWT_EVENT_QUEUE);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class AndroidExecutor
    implements Executor {
        private Object handler = null;
        private Method postMethod = null;

        AndroidExecutor() {
            try {
                Class<?> clsLooper = Class.forName(DelegateUiExecutor.CLS_ANDROID_LOOPER);
                Method getMainLooper = clsLooper.getDeclaredMethod("getMainLooper", new Class[0]);
                Object mainLooper = getMainLooper.invoke(null, new Object[0]);
                Class<?> clsHandler = Class.forName(DelegateUiExecutor.CLS_ANDROID_HANDLER);
                Constructor<?> handlerCtor = clsHandler.getConstructor(clsLooper);
                this.postMethod = clsHandler.getMethod("post", Runnable.class);
                this.handler = handlerCtor.newInstance(mainLooper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void execute(Runnable command) {
            if (this.handler == null) {
                throw new NullPointerException("handler == null");
            }
            if (this.postMethod == null) {
                throw new NullPointerException("postMethod == null");
            }
            try {
                this.postMethod.invoke(this.handler, command);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class AwtExecutor
    implements Executor {
        private Method invokeLaterMethod = null;

        AwtExecutor() {
            try {
                Class<?> clsEventQueue = Class.forName(DelegateUiExecutor.CLS_AWT_EVENT_QUEUE);
                this.invokeLaterMethod = clsEventQueue.getMethod("invokeLater", Runnable.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void execute(Runnable command) {
            if (this.invokeLaterMethod == null) {
                throw new NullPointerException("invokeLaterMethod == null");
            }
            try {
                this.invokeLaterMethod.invoke(null, command);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class BadExecutor
    implements Executor {
        private BadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            throw new IllegalStateException("Bad Executor");
        }
    }
}

