/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger index = new AtomicInteger(1);
    private final String prefix;

    public NamingThreadFactory(String name) {
        this("EventBus", name);
    }

    public NamingThreadFactory(String module, String name) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.prefix = module + "-" + name + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.prefix + this.index.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

