/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executor;
import top.fullj.eventbus.ConsoleSubscriberExceptionHandler;
import top.fullj.eventbus.DeadEvent;
import top.fullj.eventbus.NamedExecutor;
import top.fullj.eventbus.Registry;
import top.fullj.eventbus.Subscriber;
import top.fullj.eventbus.SubscriberExceptionHandler;

public class EventBus {
    private static volatile EventBus DEFAULT;
    private static final Map<String, Executor> EXECUTOR_MAP;
    private static final SubscriberExceptionHandler EXCEPTION_HANDLER;
    private final Registry registry = new Registry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBus getDefault() {
        if (DEFAULT != null) return DEFAULT;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (DEFAULT != null) return DEFAULT;
            DEFAULT = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT;
        }
    }

    private EventBus() {
    }

    public void register(Object target) {
        this.registry.register(target);
    }

    public void unregister(Object target) {
        this.registry.unregister(target);
    }

    public void post(Object event) {
        Set<Subscriber> subscribers = this.registry.getSubscribers(event.getClass());
        if (subscribers.isEmpty()) {
            if (!(event instanceof DeadEvent)) {
                this.post(new DeadEvent(this, event));
            }
        } else {
            for (Subscriber subscriber : subscribers) {
                this.execute(event, subscriber);
            }
        }
    }

    private void execute(Object event, Subscriber subscriber) {
        Method method = subscriber.method;
        Object target = subscriber.target;
        Executor executor = this.findExecutorByThreadMode(subscriber.threadMode);
        executor.execute(() -> {
            try {
                method.invoke(target, event);
            }
            catch (ReflectiveOperationException e) {
                EXCEPTION_HANDLER.handleException(this, event, target, method, e);
            }
        });
        if (subscriber.once) {
            this.registry.unsubscribe(subscriber);
        }
    }

    private Executor findExecutorByThreadMode(String threadMode) {
        Executor executor = EXECUTOR_MAP.get(threadMode);
        if (executor == null) {
            throw new IllegalArgumentException("Cant execute in: " + threadMode);
        }
        return executor;
    }

    static {
        EXECUTOR_MAP = new HashMap<String, Executor>();
        for (NamedExecutor instance : ServiceLoader.load(NamedExecutor.class)) {
            EXECUTOR_MAP.put(instance.name(), instance);
            System.out.println("top.fullj.eventbus.executor[" + instance.name() + "] = " + instance.getClass().getName());
        }
        Iterator<SubscriberExceptionHandler> it = ServiceLoader.load(SubscriberExceptionHandler.class).iterator();
        EXCEPTION_HANDLER = it.hasNext() ? it.next() : new ConsoleSubscriberExceptionHandler();
        System.out.println("top.fullj.eventbus.SubscriberExceptionHandler = " + EXCEPTION_HANDLER.getClass().getName());
    }
}

