/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.thread;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadManager
implements ExecutorService {
    ExecutorService mExecutorService;
    public static int STATE_SUCCESS = 200;

    public static ExecutorService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mExecutorService.awaitTermination(timeout, unit);
    }

    public ThreadManager(ExecutorService executorService) {
        this.mExecutorService = executorService;
    }

    public ThreadManager() {
        ThreadPoolExecutor.DiscardPolicy rejectedExecutionHandler = new ThreadPoolExecutor.DiscardPolicy();
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(2, 4, 4L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20), rejectedExecutionHandler);
        poolExecutor.allowCoreThreadTimeOut(true);
        this.mExecutorService = poolExecutor;
    }

    public static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.mExecutorService.submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.mExecutorService.submit(task);
    }

    @Override
    public void execute(Runnable runnable) {
        this.mExecutorService.execute(runnable);
    }

    @Override
    public void shutdown() {
        this.mExecutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.mExecutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.mExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.mExecutorService.isTerminated();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.mExecutorService.submit(task, result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.mExecutorService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.mExecutorService.invokeAll(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.mExecutorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        return this.mExecutorService.invokeAny(tasks);
    }

    private static class SingletonHolder {
        private static final ThreadManager INSTANCE = new ThreadManager();

        private SingletonHolder() {
        }
    }
}

