/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.rxjava2;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class ThrottleLastUtil {
    public static ThrottleLastHolder throttleLastFast(long milliseconds) {
        return new ThrottleLastHolder().throttleLastFast(milliseconds);
    }

    public static class ThrottleLastHolder
    implements Disposable {
        ObservableEmitter<Boolean> mFastEmitter;
        ObservableEmitter<Boolean> mSlowEmitter;
        Disposable mFastDisposable;
        Disposable mSlowDisposable;
        long mThrottleLastFast;
        long mThrottleLastSlow;
        long mDelayFast;
        long mDelaySlow;
        Consumer<Throwable> mThrowableConsumer;

        public ThrottleLastHolder throttleLastFast(long milliseconds) {
            this.mThrottleLastFast = milliseconds;
            return this;
        }

        public ThrottleLastHolder throttleLastSlow(long milliseconds) {
            this.mThrottleLastSlow = milliseconds;
            return this;
        }

        public ThrottleLastHolder onError(Consumer<Throwable> onError) {
            this.mThrowableConsumer = onError;
            return this;
        }

        public ThrottleLastHolder subscribe(final OnSubscribeListener listener) {
            Observable fastObservable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

                public void subscribe(ObservableEmitter<Boolean> emitter) throws Exception {
                    ThrottleLastHolder.this.mFastEmitter = emitter;
                }
            }).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).throttleLast(this.mThrottleLastFast, TimeUnit.MILLISECONDS);
            if (this.mDelayFast > 0L) {
                fastObservable = fastObservable.delay(this.mDelayFast, TimeUnit.MILLISECONDS);
            }
            fastObservable.observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Boolean>(){

                public void onSubscribe(Disposable d) {
                    ThrottleLastHolder.this.mFastDisposable = d;
                }

                public void onNext(Boolean isFast) {
                    if (isFast.booleanValue()) {
                        listener.subscribeFast();
                    } else {
                        listener.subscribeSlow();
                    }
                }

                public void onError(Throwable e) {
                    if (ThrottleLastHolder.this.mThrowableConsumer != null) {
                        try {
                            ThrottleLastHolder.this.mThrowableConsumer.accept((Object)e);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }

                public void onComplete() {
                }
            });
            Observable slowObservable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

                public void subscribe(ObservableEmitter<Boolean> emitter) throws Exception {
                    ThrottleLastHolder.this.mSlowEmitter = emitter;
                }
            }).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).throttleLast(this.mThrottleLastSlow, TimeUnit.MILLISECONDS);
            if (this.mDelaySlow > 0L) {
                slowObservable = slowObservable.delay(this.mDelaySlow, TimeUnit.MILLISECONDS);
            }
            slowObservable.observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Boolean>(){

                public void onSubscribe(Disposable d) {
                    ThrottleLastHolder.this.mSlowDisposable = d;
                }

                public void onNext(Boolean isSlow) {
                    if (isSlow.booleanValue()) {
                        ThrottleLastHolder.this.mFastEmitter.onNext((Object)false);
                    } else {
                        ThrottleLastHolder.this.mFastEmitter.onNext((Object)true);
                    }
                }

                public void onError(Throwable e) {
                    if (ThrottleLastHolder.this.mThrowableConsumer != null) {
                        try {
                            ThrottleLastHolder.this.mThrowableConsumer.accept((Object)e);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }

                public void onComplete() {
                }
            });
            listener.onSubscribe(this);
            return this;
        }

        public ThrottleLastHolder delayFast(long milliseconds) {
            this.mDelayFast = milliseconds;
            return this;
        }

        public ThrottleLastHolder delaySlow(long milliseconds) {
            this.mDelaySlow = milliseconds;
            return this;
        }

        public ThrottleLastHolder sendFastEvent() {
            if (this.mFastEmitter == null) {
                return this;
            }
            this.mFastEmitter.onNext((Object)true);
            return this;
        }

        public ThrottleLastHolder sendSlowEvent() {
            if (this.mSlowEmitter == null) {
                return this;
            }
            this.mSlowEmitter.onNext((Object)true);
            return this;
        }

        public void dispose() {
            try {
                if (this.mFastDisposable != null && !this.mFastDisposable.isDisposed()) {
                    this.mFastDisposable.dispose();
                }
                if (this.mSlowDisposable != null && !this.mSlowDisposable.isDisposed()) {
                    this.mSlowDisposable.dispose();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public boolean isDisposed() {
            return this.mFastDisposable != null && this.mSlowDisposable != null && this.mFastDisposable.isDisposed() && this.mSlowDisposable.isDisposed();
        }
    }

    public static interface OnSubscribeListener {
        public void subscribeFast();

        public void subscribeSlow();

        public void onSubscribe(ThrottleLastHolder var1);
    }
}

