/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.layout;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import top.ftas.util.size.DisplayUtil;

public class LayoutUtil {
    public static View init(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent, int resId) {
        View view = inflater.inflate(resId, parent, false);
        return LayoutUtil.init(view);
    }

    public static View init(View view) {
        if (view == null) {
            return null;
        }
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.MarginLayoutParams(-1, -2);
        } else {
            layoutParams.width = -1;
        }
        view.setLayoutParams(layoutParams);
        return view;
    }

    public static void setImageViewLayoutVisible(View view, int width, int height) {
        LayoutUtil.setImageViewLayoutVisible(view, width, height, 0);
    }

    public static void setImageViewLayoutVisible(View view, int width, int height, int dp_reduceWidth) {
        ViewGroup.LayoutParams layoutParams;
        if (view == null) {
            return;
        }
        int reduceWidth = 0;
        if (dp_reduceWidth != 0) {
            reduceWidth = DisplayUtil.dip2px(view.getContext(), dp_reduceWidth);
        }
        if ((layoutParams = view.getLayoutParams()) == null) {
            layoutParams = new LinearLayout.LayoutParams(-1, -2);
        }
        layoutParams.height = (DisplayUtil.getScreenWidth(view.getContext()) - reduceWidth) * height / width;
        view.setLayoutParams(layoutParams);
        view.setVisibility(0);
    }
}

