/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.glide;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class GlideCutLeftRightBottomTransform
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "com.bumptech.glide.load.resource.bitmap.CutLeftRightBottomTransform.1";
    private static final byte[] ID_BYTES = "com.bumptech.glide.load.resource.bitmap.CutLeftRightBottomTransform.1".getBytes(CHARSET);
    private final int roundingRadius;

    public GlideCutLeftRightBottomTransform(int pxRoundingRadius) {
        this.roundingRadius = pxRoundingRadius;
    }

    public GlideCutLeftRightBottomTransform() {
        this.roundingRadius = 0;
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        float differenceScale;
        int bitmapHeight;
        float minScale;
        Matrix matrix = new Matrix();
        int bitmapWidth = toTransform.getWidth();
        float maxScale = (float)outWidth / (float)bitmapWidth;
        if (maxScale < (minScale = (float)outHeight / (float)(bitmapHeight = toTransform.getHeight()))) {
            float tmpScale = maxScale;
            maxScale = minScale;
            minScale = tmpScale;
        }
        if ((differenceScale = maxScale / minScale) > 5.0f) {
            Log.e((String)"CutTransform", (String)"\u6bd4\u503c\u5dee\u5f97\u8fc7\u5927\uff0c\u53ef\u80fd OOM\uff0c\u4e0d\u8fdb\u884c\u7f29\u653e");
            return toTransform;
        }
        matrix.setScale(maxScale, maxScale);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)toTransform, (int)((bitmapWidth - outWidth) / 2), (int)0, (int)outWidth, (int)outHeight, (Matrix)matrix, (boolean)true);
        if (this.roundingRadius > 0) {
            newBitmap = TransformationUtils.roundedCorners((BitmapPool)pool, (Bitmap)newBitmap, (int)this.roundingRadius);
        }
        return newBitmap;
    }

    public boolean equals(Object o) {
        return o instanceof GlideCutLeftRightBottomTransform;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
        if (this.roundingRadius > 0) {
            byte[] radiusData = ByteBuffer.allocate(4).putInt(this.roundingRadius).array();
            messageDigest.update(radiusData);
        }
    }
}

