/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.dialog;

import android.app.Dialog;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;

public class DialogSettingUtil {
    public static OnCreateDialogHolder onCreateDialog(@NonNull Dialog dialog) {
        return new OnCreateDialogHolder(dialog);
    }

    public static OnStartHolder onStart(@NonNull Dialog dialog) {
        return new OnStartHolder(dialog);
    }

    public static class OnStartHolder
    extends BaseHolder<OnStartHolder> {
        private OnCreateDialogHolder mOnCreateDialogHolder;

        OnStartHolder(Dialog dialog) {
            super(dialog);
        }

        public OnStartHolder setWindowIsTransparent() {
            this.getLayoutParams().dimAmount = 0.0f;
            this.autoSetAttributes();
            return this;
        }

        public OnStartHolder setDimAmount(float dimAmount) {
            this.getLayoutParams().dimAmount = dimAmount;
            this.autoSetAttributes();
            return this;
        }

        public OnCreateDialogHolder forceOnCreateDialog() {
            if (this.mOnCreateDialogHolder == null) {
                this.mOnCreateDialogHolder = new OnCreateDialogHolder(this.mDialog);
            }
            return this.mOnCreateDialogHolder;
        }
    }

    public static class OnCreateDialogHolder
    extends BaseHolder<OnCreateDialogHolder> {
        private OnStartHolder mOnStartHolder;

        OnCreateDialogHolder(Dialog dialog) {
            super(dialog);
        }

        public OnCreateDialogHolder requestWindowFeature(int featureId) {
            this.mDialog.requestWindowFeature(featureId);
            return this;
        }

        public OnCreateDialogHolder isNoTitle() {
            this.mDialog.requestWindowFeature(1);
            return this;
        }

        public OnCreateDialogHolder setSoftInputMode(int mode) {
            if (this.mWindow == null) {
                return this;
            }
            this.mWindow.setSoftInputMode(mode);
            return this;
        }

        public OnCreateDialogHolder setDefaultDisplayWidth() {
            if (this.mWindow == null) {
                return this;
            }
            Display display = this.mWindow.getWindowManager().getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            this.getLayoutParams().width = size.x;
            this.autoSetAttributes();
            return this;
        }

        public OnCreateDialogHolder setCanceledOnTouchOutside(boolean cancel) {
            this.mDialog.setCanceledOnTouchOutside(cancel);
            return this;
        }

        public OnCreateDialogHolder setCancelable(boolean flag) {
            this.mDialog.setCancelable(flag);
            return this;
        }

        public OnCreateDialogHolder setContentTransparent() {
            if (this.mWindow == null) {
                return this;
            }
            this.mWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            return this;
        }

        public OnStartHolder forceOnStart() {
            if (this.mOnStartHolder == null) {
                this.mOnStartHolder = new OnStartHolder(this.mDialog);
            }
            return this.mOnStartHolder;
        }

        public OnCreateDialogHolder setWindowFlags(int flags) {
            this.getLayoutParams().flags = flags;
            this.autoSetAttributes();
            return this;
        }

        public OnCreateDialogHolder setGravity(int gravity) {
            if (this.mWindow == null) {
                return this;
            }
            this.mWindow.setGravity(gravity);
            return this;
        }

        public OnCreateDialogHolder setWindowAnimations(@StyleRes int resId) {
            if (this.mWindow == null) {
                return this;
            }
            this.mWindow.setWindowAnimations(resId);
            return this;
        }

        public OnCreateDialogHolder setBottomCenter() {
            if (this.mWindow == null) {
                return this;
            }
            this.mWindow.setGravity(81);
            return this;
        }

        public OnCreateDialogHolder setCenterCenter() {
            if (this.mWindow == null) {
                return this;
            }
            this.mWindow.setGravity(17);
            return this;
        }

        public OnCreateDialogHolder canClickBelowView() {
            this.getLayoutParams().flags = 8;
            this.autoSetAttributes();
            return this;
        }
    }

    private static class BaseHolder<T> {
        WindowManager.LayoutParams mLayoutParams;
        Dialog mDialog;
        Window mWindow;

        BaseHolder(Dialog dialog) {
            this.mDialog = dialog;
            this.mWindow = this.mDialog.getWindow();
        }

        public T setLayout(int width, int height) {
            if (this.mWindow == null) {
                return (T)this;
            }
            this.mWindow.setLayout(width, height);
            return (T)this;
        }

        public T setLayoutMatchWrap() {
            if (this.mWindow == null) {
                return (T)this;
            }
            this.mWindow.setLayout(-1, -2);
            return (T)this;
        }

        @NonNull
        WindowManager.LayoutParams getLayoutParams() {
            if (this.mLayoutParams == null && this.mWindow != null) {
                this.mLayoutParams = this.mWindow.getAttributes();
            }
            if (this.mLayoutParams == null) {
                this.mLayoutParams = new WindowManager.LayoutParams(-1, -1);
            }
            return this.mLayoutParams;
        }

        public Dialog toDialog() {
            return this.mDialog;
        }

        void autoSetAttributes() {
            if (this.mWindow != null) {
                this.mWindow.setAttributes(this.getLayoutParams());
            }
            this.mLayoutParams = null;
        }
    }
}

