/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.bitmap;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.ScrollView;
import androidx.appcompat.widget.AppCompatImageView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DisplayBigPictureUtil {
    public static View getDisplayBigPictureView(Context context) {
        return DisplayBigPictureUtil.getDisplayBigPictureView(context, true);
    }

    public static View getDisplayBigPictureView(Context context, boolean canZoon) {
        if (canZoon) {
            return DisplayBigPictureUtil.getDisplayBigPictureCanZoomView(context);
        }
        ScrollView scrollView = new ScrollView(context);
        ViewGroup.LayoutParams scrollViewParams = new ViewGroup.LayoutParams(-1, -1);
        scrollView.setLayoutParams(scrollViewParams);
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(context);
        FrameLayout.LayoutParams horizontalParams = new FrameLayout.LayoutParams(-1, -1);
        scrollView.addView((View)horizontalScrollView, (ViewGroup.LayoutParams)horizontalParams);
        ImageView imageView = new ImageView(context);
        FrameLayout.LayoutParams imageParams = new FrameLayout.LayoutParams(-2, -2);
        horizontalScrollView.addView((View)imageView);
        imageView.setId(16908294);
        return scrollView;
    }

    public static View getDisplayBigPictureViewWithActionBtn(Context context, boolean canZoom, String actionBtnText, View.OnClickListener onClickListener) {
        FrameLayout frameLayout = new FrameLayout(context);
        ViewGroup.LayoutParams frameParams = new ViewGroup.LayoutParams(-1, -1);
        frameLayout.setLayoutParams(frameParams);
        View displayView = DisplayBigPictureUtil.getDisplayBigPictureView(context, canZoom);
        frameLayout.addView(displayView);
        Button button = new Button(context);
        button.setId(16908313);
        button.setText((CharSequence)actionBtnText);
        FrameLayout.LayoutParams btnParams = new FrameLayout.LayoutParams(-2, -2);
        btnParams.gravity = 17;
        button.setAlpha(0.4f);
        button.setOnClickListener(onClickListener);
        button.setLayoutParams((ViewGroup.LayoutParams)btnParams);
        frameLayout.addView((View)button);
        return frameLayout;
    }

    public static View getDisplayBigPictureCanZoomView(Context context) {
        MyBigDrawableImageView myBigDrawableImageView = new MyBigDrawableImageView(context);
        myBigDrawableImageView.setId(16908294);
        return myBigDrawableImageView;
    }

    private static class MyBigDrawableImageView
    extends AppCompatImageView {
        public static final int SCALE_ANIMATOR_DURATION = 200;
        public static final float FLING_DAMPING_FACTOR = 0.9f;
        private static final float MAX_SCALE = 4.0f;
        private View.OnClickListener mOnClickListener;
        private View.OnLongClickListener mOnLongClickListener;
        public static final int PINCH_MODE_FREE = 0;
        public static final int PINCH_MODE_SCROLL = 1;
        public static final int PINCH_MODE_SCALE = 2;
        private Matrix mOuterMatrix = new Matrix();
        private RectF mMask;
        private int mPinchMode = 0;
        private List<OuterMatrixChangedListener> mOuterMatrixChangedListeners;
        private List<OuterMatrixChangedListener> mOuterMatrixChangedListenersCopy;
        private int mDispatchOuterMatrixChangedLock;
        private MaskAnimator mMaskAnimator;
        private PointF mLastMovePoint = new PointF();
        private PointF mScaleCenter = new PointF();
        private float mScaleBase = 0.0f;
        private ScaleAnimator mScaleAnimator;
        private FlingAnimator mFlingAnimator;
        private GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (!(MyBigDrawableImageView.this.mPinchMode != 0 || MyBigDrawableImageView.this.mScaleAnimator != null && MyBigDrawableImageView.this.mScaleAnimator.isRunning())) {
                    MyBigDrawableImageView.this.fling(velocityX, velocityY);
                }
                return true;
            }

            public void onLongPress(MotionEvent e) {
                if (MyBigDrawableImageView.this.mOnLongClickListener != null) {
                    MyBigDrawableImageView.this.mOnLongClickListener.onLongClick((View)MyBigDrawableImageView.this);
                }
            }

            public boolean onDoubleTap(MotionEvent e) {
                if (!(MyBigDrawableImageView.this.mPinchMode != 1 || MyBigDrawableImageView.this.mScaleAnimator != null && MyBigDrawableImageView.this.mScaleAnimator.isRunning())) {
                    MyBigDrawableImageView.this.doubleTap(e.getX(), e.getY());
                }
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (MyBigDrawableImageView.this.mOnClickListener != null) {
                    MyBigDrawableImageView.this.mOnClickListener.onClick((View)MyBigDrawableImageView.this);
                }
                return true;
            }
        });

        public void setOnClickListener(View.OnClickListener l) {
            this.mOnClickListener = l;
        }

        public void setOnLongClickListener(View.OnLongClickListener l) {
            this.mOnLongClickListener = l;
        }

        public Matrix getOuterMatrix(Matrix matrix) {
            if (matrix == null) {
                matrix = new Matrix(this.mOuterMatrix);
            } else {
                matrix.set(this.mOuterMatrix);
            }
            return matrix;
        }

        public Matrix getInnerMatrix(Matrix matrix) {
            if (matrix == null) {
                matrix = new Matrix();
            } else {
                matrix.reset();
            }
            if (this.isReady()) {
                RectF tempSrc = MathUtils.rectFTake(0.0f, 0.0f, this.getDrawable().getIntrinsicWidth(), this.getDrawable().getIntrinsicHeight());
                RectF tempDst = MathUtils.rectFTake(0.0f, 0.0f, this.getWidth(), this.getHeight());
                matrix.setRectToRect(tempSrc, tempDst, Matrix.ScaleToFit.CENTER);
                MathUtils.rectFGiven(tempDst);
                MathUtils.rectFGiven(tempSrc);
            }
            return matrix;
        }

        public Matrix getCurrentImageMatrix(Matrix matrix) {
            matrix = this.getInnerMatrix(matrix);
            matrix.postConcat(this.mOuterMatrix);
            return matrix;
        }

        public RectF getImageBound(RectF rectF) {
            if (rectF == null) {
                rectF = new RectF();
            } else {
                rectF.setEmpty();
            }
            if (!this.isReady()) {
                return rectF;
            }
            Matrix matrix = MathUtils.matrixTake();
            this.getCurrentImageMatrix(matrix);
            rectF.set(0.0f, 0.0f, (float)this.getDrawable().getIntrinsicWidth(), (float)this.getDrawable().getIntrinsicHeight());
            matrix.mapRect(rectF);
            MathUtils.matrixGiven(matrix);
            return rectF;
        }

        public RectF getMask() {
            if (this.mMask != null) {
                return new RectF(this.mMask);
            }
            return null;
        }

        public int getPinchMode() {
            return this.mPinchMode;
        }

        public boolean canScrollHorizontally(int direction) {
            if (this.mPinchMode == 2) {
                return true;
            }
            RectF bound = this.getImageBound(null);
            if (bound == null) {
                return false;
            }
            if (bound.isEmpty()) {
                return false;
            }
            if (direction > 0) {
                return bound.right > (float)this.getWidth();
            }
            return bound.left < 0.0f;
        }

        public boolean canScrollVertically(int direction) {
            if (this.mPinchMode == 2) {
                return true;
            }
            RectF bound = this.getImageBound(null);
            if (bound == null) {
                return false;
            }
            if (bound.isEmpty()) {
                return false;
            }
            if (direction > 0) {
                return bound.bottom > (float)this.getHeight();
            }
            return bound.top < 0.0f;
        }

        public void outerMatrixTo(Matrix endMatrix, long duration) {
            if (endMatrix == null) {
                return;
            }
            this.mPinchMode = 0;
            this.cancelAllAnimator();
            if (duration <= 0L) {
                this.mOuterMatrix.set(endMatrix);
                this.dispatchOuterMatrixChanged();
                this.invalidate();
            } else {
                this.mScaleAnimator = new ScaleAnimator(this.mOuterMatrix, endMatrix, duration);
                this.mScaleAnimator.start();
            }
        }

        public void zoomMaskTo(RectF mask, long duration) {
            if (mask == null) {
                return;
            }
            if (this.mMaskAnimator != null) {
                this.mMaskAnimator.cancel();
                this.mMaskAnimator = null;
            }
            if (duration <= 0L || this.mMask == null) {
                if (this.mMask == null) {
                    this.mMask = new RectF();
                }
                this.mMask.set(mask);
                this.invalidate();
            } else {
                this.mMaskAnimator = new MaskAnimator(this.mMask, mask, duration);
                this.mMaskAnimator.start();
            }
        }

        public void reset() {
            this.mOuterMatrix.reset();
            this.dispatchOuterMatrixChanged();
            this.mMask = null;
            this.mPinchMode = 0;
            this.mLastMovePoint.set(0.0f, 0.0f);
            this.mScaleCenter.set(0.0f, 0.0f);
            this.mScaleBase = 0.0f;
            if (this.mMaskAnimator != null) {
                this.mMaskAnimator.cancel();
                this.mMaskAnimator = null;
            }
            this.cancelAllAnimator();
            this.invalidate();
        }

        public void addOuterMatrixChangedListener(OuterMatrixChangedListener listener) {
            if (listener == null) {
                return;
            }
            if (this.mDispatchOuterMatrixChangedLock == 0) {
                if (this.mOuterMatrixChangedListeners == null) {
                    this.mOuterMatrixChangedListeners = new ArrayList<OuterMatrixChangedListener>();
                }
                this.mOuterMatrixChangedListeners.add(listener);
            } else {
                if (this.mOuterMatrixChangedListenersCopy == null) {
                    this.mOuterMatrixChangedListenersCopy = this.mOuterMatrixChangedListeners != null ? new ArrayList<OuterMatrixChangedListener>(this.mOuterMatrixChangedListeners) : new ArrayList<OuterMatrixChangedListener>();
                }
                this.mOuterMatrixChangedListenersCopy.add(listener);
            }
        }

        public void removeOuterMatrixChangedListener(OuterMatrixChangedListener listener) {
            if (listener == null) {
                return;
            }
            if (this.mDispatchOuterMatrixChangedLock == 0) {
                if (this.mOuterMatrixChangedListeners != null) {
                    this.mOuterMatrixChangedListeners.remove(listener);
                }
            } else {
                if (this.mOuterMatrixChangedListenersCopy == null && this.mOuterMatrixChangedListeners != null) {
                    this.mOuterMatrixChangedListenersCopy = new ArrayList<OuterMatrixChangedListener>(this.mOuterMatrixChangedListeners);
                }
                if (this.mOuterMatrixChangedListenersCopy != null) {
                    this.mOuterMatrixChangedListenersCopy.remove(listener);
                }
            }
        }

        private void dispatchOuterMatrixChanged() {
            if (this.mOuterMatrixChangedListeners == null) {
                return;
            }
            ++this.mDispatchOuterMatrixChangedLock;
            for (OuterMatrixChangedListener listener : this.mOuterMatrixChangedListeners) {
                listener.onOuterMatrixChanged(this);
            }
            --this.mDispatchOuterMatrixChangedLock;
            if (this.mDispatchOuterMatrixChangedLock == 0 && this.mOuterMatrixChangedListenersCopy != null) {
                this.mOuterMatrixChangedListeners = this.mOuterMatrixChangedListenersCopy;
                this.mOuterMatrixChangedListenersCopy = null;
            }
        }

        protected float getMaxScale() {
            return 4.0f;
        }

        protected float calculateNextScale(float innerScale, float outerScale) {
            float currentScale = innerScale * outerScale;
            if (currentScale < 4.0f) {
                return 4.0f;
            }
            return innerScale;
        }

        public MyBigDrawableImageView(Context context) {
            super(context);
            this.initView();
        }

        public MyBigDrawableImageView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.initView();
        }

        public MyBigDrawableImageView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.initView();
        }

        private void initView() {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        }

        public void setScaleType(ImageView.ScaleType scaleType) {
        }

        protected void onDraw(Canvas canvas) {
            if (this.isReady()) {
                Matrix matrix = MathUtils.matrixTake();
                this.setImageMatrix(this.getCurrentImageMatrix(matrix));
                MathUtils.matrixGiven(matrix);
            }
            if (this.mMask != null) {
                canvas.save();
                canvas.clipRect(this.mMask);
                super.onDraw(canvas);
                canvas.restore();
            } else {
                super.onDraw(canvas);
            }
        }

        private boolean isReady() {
            return this.getDrawable() != null && this.getDrawable().getIntrinsicWidth() > 0 && this.getDrawable().getIntrinsicHeight() > 0 && this.getWidth() > 0 && this.getHeight() > 0;
        }

        public boolean onTouchEvent(MotionEvent event) {
            super.onTouchEvent(event);
            int action = event.getAction() & 0xFF;
            if (action == 1 || action == 3) {
                if (this.mPinchMode == 2) {
                    this.scaleEnd();
                }
                this.mPinchMode = 0;
            } else if (action == 6) {
                if (this.mPinchMode == 2 && event.getPointerCount() > 2) {
                    if (event.getAction() >> 8 == 0) {
                        this.saveScaleContext(event.getX(1), event.getY(1), event.getX(2), event.getY(2));
                    } else if (event.getAction() >> 8 == 1) {
                        this.saveScaleContext(event.getX(0), event.getY(0), event.getX(2), event.getY(2));
                    }
                }
            } else if (action == 0) {
                if (this.mScaleAnimator == null || !this.mScaleAnimator.isRunning()) {
                    this.cancelAllAnimator();
                    this.mPinchMode = 1;
                    this.mLastMovePoint.set(event.getX(), event.getY());
                }
            } else if (action == 5) {
                this.cancelAllAnimator();
                this.mPinchMode = 2;
                this.saveScaleContext(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
            } else if (!(action != 2 || this.mScaleAnimator != null && this.mScaleAnimator.isRunning())) {
                if (this.mPinchMode == 1) {
                    this.scrollBy(event.getX() - this.mLastMovePoint.x, event.getY() - this.mLastMovePoint.y);
                    this.mLastMovePoint.set(event.getX(), event.getY());
                } else if (this.mPinchMode == 2 && event.getPointerCount() > 1) {
                    float distance = MathUtils.getDistance(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                    float[] lineCenter = MathUtils.getCenterPoint(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                    this.mLastMovePoint.set(lineCenter[0], lineCenter[1]);
                    this.scale(this.mScaleCenter, this.mScaleBase, distance, this.mLastMovePoint);
                }
            }
            this.mGestureDetector.onTouchEvent(event);
            return true;
        }

        private boolean scrollBy(float xDiff, float yDiff) {
            if (!this.isReady()) {
                return false;
            }
            RectF bound = MathUtils.rectFTake();
            this.getImageBound(bound);
            float displayWidth = this.getWidth();
            float displayHeight = this.getHeight();
            if (bound.right - bound.left < displayWidth) {
                xDiff = 0.0f;
            } else if (bound.left + xDiff > 0.0f) {
                xDiff = bound.left < 0.0f ? -bound.left : 0.0f;
            } else if (bound.right + xDiff < displayWidth) {
                xDiff = bound.right > displayWidth ? displayWidth - bound.right : 0.0f;
            }
            if (bound.bottom - bound.top < displayHeight) {
                yDiff = 0.0f;
            } else if (bound.top + yDiff > 0.0f) {
                yDiff = bound.top < 0.0f ? -bound.top : 0.0f;
            } else if (bound.bottom + yDiff < displayHeight) {
                yDiff = bound.bottom > displayHeight ? displayHeight - bound.bottom : 0.0f;
            }
            MathUtils.rectFGiven(bound);
            this.mOuterMatrix.postTranslate(xDiff, yDiff);
            this.dispatchOuterMatrixChanged();
            this.invalidate();
            return xDiff != 0.0f || yDiff != 0.0f;
        }

        private void saveScaleContext(float x1, float y1, float x2, float y2) {
            this.mScaleBase = MathUtils.getMatrixScale(this.mOuterMatrix)[0] / MathUtils.getDistance(x1, y1, x2, y2);
            float[] center = MathUtils.inverseMatrixPoint(MathUtils.getCenterPoint(x1, y1, x2, y2), this.mOuterMatrix);
            this.mScaleCenter.set(center[0], center[1]);
        }

        private void scale(PointF scaleCenter, float scaleBase, float distance, PointF lineCenter) {
            if (!this.isReady()) {
                return;
            }
            float scale = scaleBase * distance;
            Matrix matrix = MathUtils.matrixTake();
            matrix.postScale(scale, scale, scaleCenter.x, scaleCenter.y);
            matrix.postTranslate(lineCenter.x - scaleCenter.x, lineCenter.y - scaleCenter.y);
            this.mOuterMatrix.set(matrix);
            MathUtils.matrixGiven(matrix);
            this.dispatchOuterMatrixChanged();
            this.invalidate();
        }

        private void doubleTap(float x, float y) {
            if (!this.isReady()) {
                return;
            }
            Matrix innerMatrix = MathUtils.matrixTake();
            this.getInnerMatrix(innerMatrix);
            float innerScale = MathUtils.getMatrixScale(innerMatrix)[0];
            float outerScale = MathUtils.getMatrixScale(this.mOuterMatrix)[0];
            float currentScale = innerScale * outerScale;
            float displayWidth = this.getWidth();
            float displayHeight = this.getHeight();
            float maxScale = this.getMaxScale();
            float nextScale = this.calculateNextScale(innerScale, outerScale);
            if (nextScale > maxScale) {
                nextScale = maxScale;
            }
            if (nextScale < innerScale) {
                nextScale = innerScale;
            }
            Matrix animEnd = MathUtils.matrixTake(this.mOuterMatrix);
            animEnd.postScale(nextScale / currentScale, nextScale / currentScale, x, y);
            animEnd.postTranslate(displayWidth / 2.0f - x, displayHeight / 2.0f - y);
            Matrix testMatrix = MathUtils.matrixTake(innerMatrix);
            testMatrix.postConcat(animEnd);
            RectF testBound = MathUtils.rectFTake(0.0f, 0.0f, this.getDrawable().getIntrinsicWidth(), this.getDrawable().getIntrinsicHeight());
            testMatrix.mapRect(testBound);
            float postX = 0.0f;
            float postY = 0.0f;
            if (testBound.right - testBound.left < displayWidth) {
                postX = displayWidth / 2.0f - (testBound.right + testBound.left) / 2.0f;
            } else if (testBound.left > 0.0f) {
                postX = -testBound.left;
            } else if (testBound.right < displayWidth) {
                postX = displayWidth - testBound.right;
            }
            if (testBound.bottom - testBound.top < displayHeight) {
                postY = displayHeight / 2.0f - (testBound.bottom + testBound.top) / 2.0f;
            } else if (testBound.top > 0.0f) {
                postY = -testBound.top;
            } else if (testBound.bottom < displayHeight) {
                postY = displayHeight - testBound.bottom;
            }
            animEnd.postTranslate(postX, postY);
            this.cancelAllAnimator();
            this.mScaleAnimator = new ScaleAnimator(this.mOuterMatrix, animEnd);
            this.mScaleAnimator.start();
            MathUtils.rectFGiven(testBound);
            MathUtils.matrixGiven(testMatrix);
            MathUtils.matrixGiven(animEnd);
            MathUtils.matrixGiven(innerMatrix);
        }

        private void scaleEnd() {
            if (!this.isReady()) {
                return;
            }
            boolean change = false;
            Matrix currentMatrix = MathUtils.matrixTake();
            this.getCurrentImageMatrix(currentMatrix);
            float currentScale = MathUtils.getMatrixScale(currentMatrix)[0];
            float outerScale = MathUtils.getMatrixScale(this.mOuterMatrix)[0];
            float displayWidth = this.getWidth();
            float displayHeight = this.getHeight();
            float maxScale = this.getMaxScale();
            float scalePost = 1.0f;
            float postX = 0.0f;
            float postY = 0.0f;
            if (currentScale > maxScale) {
                scalePost = maxScale / currentScale;
            }
            if (outerScale * scalePost < 1.0f) {
                scalePost = 1.0f / outerScale;
            }
            if (scalePost != 1.0f) {
                change = true;
            }
            Matrix testMatrix = MathUtils.matrixTake(currentMatrix);
            testMatrix.postScale(scalePost, scalePost, this.mLastMovePoint.x, this.mLastMovePoint.y);
            RectF testBound = MathUtils.rectFTake(0.0f, 0.0f, this.getDrawable().getIntrinsicWidth(), this.getDrawable().getIntrinsicHeight());
            testMatrix.mapRect(testBound);
            if (testBound.right - testBound.left < displayWidth) {
                postX = displayWidth / 2.0f - (testBound.right + testBound.left) / 2.0f;
            } else if (testBound.left > 0.0f) {
                postX = -testBound.left;
            } else if (testBound.right < displayWidth) {
                postX = displayWidth - testBound.right;
            }
            if (testBound.bottom - testBound.top < displayHeight) {
                postY = displayHeight / 2.0f - (testBound.bottom + testBound.top) / 2.0f;
            } else if (testBound.top > 0.0f) {
                postY = -testBound.top;
            } else if (testBound.bottom < displayHeight) {
                postY = displayHeight - testBound.bottom;
            }
            if (postX != 0.0f || postY != 0.0f) {
                change = true;
            }
            if (change) {
                Matrix animEnd = MathUtils.matrixTake(this.mOuterMatrix);
                animEnd.postScale(scalePost, scalePost, this.mLastMovePoint.x, this.mLastMovePoint.y);
                animEnd.postTranslate(postX, postY);
                this.cancelAllAnimator();
                this.mScaleAnimator = new ScaleAnimator(this.mOuterMatrix, animEnd);
                this.mScaleAnimator.start();
                MathUtils.matrixGiven(animEnd);
            }
            MathUtils.rectFGiven(testBound);
            MathUtils.matrixGiven(testMatrix);
            MathUtils.matrixGiven(currentMatrix);
        }

        private void fling(float vx, float vy) {
            if (!this.isReady()) {
                return;
            }
            this.cancelAllAnimator();
            this.mFlingAnimator = new FlingAnimator(vx / 60.0f, vy / 60.0f);
            this.mFlingAnimator.start();
        }

        private void cancelAllAnimator() {
            if (this.mScaleAnimator != null) {
                this.mScaleAnimator.cancel();
                this.mScaleAnimator = null;
            }
            if (this.mFlingAnimator != null) {
                this.mFlingAnimator.cancel();
                this.mFlingAnimator = null;
            }
        }

        public static class MathUtils {
            private static MatrixPool mMatrixPool = new MatrixPool(16);
            private static RectFPool mRectFPool = new RectFPool(16);

            public static Matrix matrixTake() {
                return (Matrix)mMatrixPool.take();
            }

            public static Matrix matrixTake(Matrix matrix) {
                Matrix result = (Matrix)mMatrixPool.take();
                if (matrix != null) {
                    result.set(matrix);
                }
                return result;
            }

            public static void matrixGiven(Matrix matrix) {
                mMatrixPool.given(matrix);
            }

            public static RectF rectFTake() {
                return (RectF)mRectFPool.take();
            }

            public static RectF rectFTake(float left, float top, float right, float bottom) {
                RectF result = (RectF)mRectFPool.take();
                result.set(left, top, right, bottom);
                return result;
            }

            public static RectF rectFTake(RectF rectF) {
                RectF result = (RectF)mRectFPool.take();
                if (rectF != null) {
                    result.set(rectF);
                }
                return result;
            }

            public static void rectFGiven(RectF rectF) {
                mRectFPool.given(rectF);
            }

            public static float getDistance(float x1, float y1, float x2, float y2) {
                float x = x1 - x2;
                float y = y1 - y2;
                return (float)Math.sqrt(x * x + y * y);
            }

            public static float[] getCenterPoint(float x1, float y1, float x2, float y2) {
                return new float[]{(x1 + x2) / 2.0f, (y1 + y2) / 2.0f};
            }

            public static float[] getMatrixScale(Matrix matrix) {
                if (matrix != null) {
                    float[] value = new float[9];
                    matrix.getValues(value);
                    return new float[]{value[0], value[4]};
                }
                return new float[2];
            }

            public static float[] inverseMatrixPoint(float[] point, Matrix matrix) {
                if (point != null && matrix != null) {
                    float[] dst = new float[2];
                    Matrix inverse = MathUtils.matrixTake();
                    matrix.invert(inverse);
                    inverse.mapPoints(dst, point);
                    MathUtils.matrixGiven(inverse);
                    return dst;
                }
                return new float[2];
            }

            public static void calculateRectTranslateMatrix(RectF from, RectF to, Matrix result) {
                if (from == null || to == null || result == null) {
                    return;
                }
                if (from.width() == 0.0f || from.height() == 0.0f) {
                    return;
                }
                result.reset();
                result.postTranslate(-from.left, -from.top);
                result.postScale(to.width() / from.width(), to.height() / from.height());
                result.postTranslate(to.left, to.top);
            }

            public static void calculateScaledRectInContainer(RectF container, float srcWidth, float srcHeight, ImageView.ScaleType scaleType, RectF result) {
                if (container == null || result == null) {
                    return;
                }
                if (srcWidth == 0.0f || srcHeight == 0.0f) {
                    return;
                }
                if (scaleType == null) {
                    scaleType = ImageView.ScaleType.FIT_CENTER;
                }
                result.setEmpty();
                if (ImageView.ScaleType.FIT_XY.equals((Object)scaleType)) {
                    result.set(container);
                } else if (ImageView.ScaleType.CENTER.equals((Object)scaleType)) {
                    Matrix matrix = MathUtils.matrixTake();
                    RectF rect = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    matrix.setTranslate((container.width() - srcWidth) * 0.5f, (container.height() - srcHeight) * 0.5f);
                    matrix.mapRect(result, rect);
                    MathUtils.rectFGiven(rect);
                    MathUtils.matrixGiven(matrix);
                    result.left += container.left;
                    result.right += container.left;
                    result.top += container.top;
                    result.bottom += container.top;
                } else if (ImageView.ScaleType.CENTER_CROP.equals((Object)scaleType)) {
                    float scale;
                    Matrix matrix = MathUtils.matrixTake();
                    RectF rect = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    float dx = 0.0f;
                    float dy = 0.0f;
                    if (srcWidth * container.height() > container.width() * srcHeight) {
                        scale = container.height() / srcHeight;
                        dx = (container.width() - srcWidth * scale) * 0.5f;
                    } else {
                        scale = container.width() / srcWidth;
                        dy = (container.height() - srcHeight * scale) * 0.5f;
                    }
                    matrix.setScale(scale, scale);
                    matrix.postTranslate(dx, dy);
                    matrix.mapRect(result, rect);
                    MathUtils.rectFGiven(rect);
                    MathUtils.matrixGiven(matrix);
                    result.left += container.left;
                    result.right += container.left;
                    result.top += container.top;
                    result.bottom += container.top;
                } else if (ImageView.ScaleType.CENTER_INSIDE.equals((Object)scaleType)) {
                    Matrix matrix = MathUtils.matrixTake();
                    RectF rect = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    float scale = srcWidth <= container.width() && srcHeight <= container.height() ? 1.0f : Math.min(container.width() / srcWidth, container.height() / srcHeight);
                    float dx = (container.width() - srcWidth * scale) * 0.5f;
                    float dy = (container.height() - srcHeight * scale) * 0.5f;
                    matrix.setScale(scale, scale);
                    matrix.postTranslate(dx, dy);
                    matrix.mapRect(result, rect);
                    MathUtils.rectFGiven(rect);
                    MathUtils.matrixGiven(matrix);
                    result.left += container.left;
                    result.right += container.left;
                    result.top += container.top;
                    result.bottom += container.top;
                } else if (ImageView.ScaleType.FIT_CENTER.equals((Object)scaleType)) {
                    Matrix matrix = MathUtils.matrixTake();
                    RectF rect = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    RectF tempSrc = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    RectF tempDst = MathUtils.rectFTake(0.0f, 0.0f, container.width(), container.height());
                    matrix.setRectToRect(tempSrc, tempDst, Matrix.ScaleToFit.CENTER);
                    matrix.mapRect(result, rect);
                    MathUtils.rectFGiven(tempDst);
                    MathUtils.rectFGiven(tempSrc);
                    MathUtils.rectFGiven(rect);
                    MathUtils.matrixGiven(matrix);
                    result.left += container.left;
                    result.right += container.left;
                    result.top += container.top;
                    result.bottom += container.top;
                } else if (ImageView.ScaleType.FIT_START.equals((Object)scaleType)) {
                    Matrix matrix = MathUtils.matrixTake();
                    RectF rect = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    RectF tempSrc = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    RectF tempDst = MathUtils.rectFTake(0.0f, 0.0f, container.width(), container.height());
                    matrix.setRectToRect(tempSrc, tempDst, Matrix.ScaleToFit.START);
                    matrix.mapRect(result, rect);
                    MathUtils.rectFGiven(tempDst);
                    MathUtils.rectFGiven(tempSrc);
                    MathUtils.rectFGiven(rect);
                    MathUtils.matrixGiven(matrix);
                    result.left += container.left;
                    result.right += container.left;
                    result.top += container.top;
                    result.bottom += container.top;
                } else if (ImageView.ScaleType.FIT_END.equals((Object)scaleType)) {
                    Matrix matrix = MathUtils.matrixTake();
                    RectF rect = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    RectF tempSrc = MathUtils.rectFTake(0.0f, 0.0f, srcWidth, srcHeight);
                    RectF tempDst = MathUtils.rectFTake(0.0f, 0.0f, container.width(), container.height());
                    matrix.setRectToRect(tempSrc, tempDst, Matrix.ScaleToFit.END);
                    matrix.mapRect(result, rect);
                    MathUtils.rectFGiven(tempDst);
                    MathUtils.rectFGiven(tempSrc);
                    MathUtils.rectFGiven(rect);
                    MathUtils.matrixGiven(matrix);
                    result.left += container.left;
                    result.right += container.left;
                    result.top += container.top;
                    result.bottom += container.top;
                } else {
                    result.set(container);
                }
            }
        }

        private static class RectFPool
        extends ObjectsPool<RectF> {
            public RectFPool(int size) {
                super(size);
            }

            @Override
            protected RectF newInstance() {
                return new RectF();
            }

            @Override
            protected RectF resetInstance(RectF obj) {
                obj.setEmpty();
                return obj;
            }
        }

        private static class MatrixPool
        extends ObjectsPool<Matrix> {
            public MatrixPool(int size) {
                super(size);
            }

            @Override
            protected Matrix newInstance() {
                return new Matrix();
            }

            @Override
            protected Matrix resetInstance(Matrix obj) {
                obj.reset();
                return obj;
            }
        }

        private static abstract class ObjectsPool<T> {
            private int mSize;
            private Queue<T> mQueue;

            public ObjectsPool(int size) {
                this.mSize = size;
                this.mQueue = new LinkedList<T>();
            }

            public T take() {
                if (this.mQueue.size() == 0) {
                    return this.newInstance();
                }
                return this.resetInstance(this.mQueue.poll());
            }

            public void given(T obj) {
                if (obj != null && this.mQueue.size() < this.mSize) {
                    this.mQueue.offer(obj);
                }
            }

            protected abstract T newInstance();

            protected abstract T resetInstance(T var1);
        }

        private class ScaleAnimator
        extends ValueAnimator
        implements ValueAnimator.AnimatorUpdateListener {
            private float[] mStart = new float[9];
            private float[] mEnd = new float[9];
            private float[] mResult = new float[9];

            public ScaleAnimator(Matrix start, Matrix end) {
                this(start, end, 200L);
            }

            public ScaleAnimator(Matrix start, Matrix end, long duration) {
                this.setFloatValues(new float[]{0.0f, 1.0f});
                this.setDuration(duration);
                this.addUpdateListener(this);
                start.getValues(this.mStart);
                end.getValues(this.mEnd);
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                for (int i = 0; i < 9; ++i) {
                    this.mResult[i] = this.mStart[i] + (this.mEnd[i] - this.mStart[i]) * value;
                }
                MyBigDrawableImageView.this.mOuterMatrix.setValues(this.mResult);
                MyBigDrawableImageView.this.dispatchOuterMatrixChanged();
                MyBigDrawableImageView.this.invalidate();
            }
        }

        private class FlingAnimator
        extends ValueAnimator
        implements ValueAnimator.AnimatorUpdateListener {
            private float[] mVector;

            public FlingAnimator(float vectorX, float vectorY) {
                this.setFloatValues(new float[]{0.0f, 1.0f});
                this.setDuration(1000000L);
                this.addUpdateListener(this);
                this.mVector = new float[]{vectorX, vectorY};
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                boolean result = MyBigDrawableImageView.this.scrollBy(this.mVector[0], this.mVector[1]);
                this.mVector[0] = this.mVector[0] * 0.9f;
                this.mVector[1] = this.mVector[1] * 0.9f;
                if (!result || MathUtils.getDistance(0.0f, 0.0f, this.mVector[0], this.mVector[1]) < 1.0f) {
                    animation.cancel();
                }
            }
        }

        private class MaskAnimator
        extends ValueAnimator
        implements ValueAnimator.AnimatorUpdateListener {
            private float[] mStart = new float[4];
            private float[] mEnd = new float[4];
            private float[] mResult = new float[4];

            public MaskAnimator(RectF start, RectF end, long duration) {
                this.setFloatValues(new float[]{0.0f, 1.0f});
                this.setDuration(duration);
                this.addUpdateListener(this);
                this.mStart[0] = start.left;
                this.mStart[1] = start.top;
                this.mStart[2] = start.right;
                this.mStart[3] = start.bottom;
                this.mEnd[0] = end.left;
                this.mEnd[1] = end.top;
                this.mEnd[2] = end.right;
                this.mEnd[3] = end.bottom;
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                for (int i = 0; i < 4; ++i) {
                    this.mResult[i] = this.mStart[i] + (this.mEnd[i] - this.mStart[i]) * value;
                }
                if (MyBigDrawableImageView.this.mMask == null) {
                    MyBigDrawableImageView.this.mMask = new RectF();
                }
                MyBigDrawableImageView.this.mMask.set(this.mResult[0], this.mResult[1], this.mResult[2], this.mResult[3]);
                MyBigDrawableImageView.this.invalidate();
            }
        }

        public static interface OuterMatrixChangedListener {
            public void onOuterMatrixChanged(MyBigDrawableImageView var1);
        }
    }
}

