/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.string;

import android.content.Context;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

public class SpannableStringBuilder {
    public final String TAG = "SpannableStringBuilder";
    private Context mContext;
    private SpannableString mSpannableString;
    private CurrentSubStrProperty mCurrentSubStrProperty;
    private boolean mHasSetOnClickListener;
    private boolean mHasSetMovementMethod;
    private Manual mManual;

    public static void printError(String message) {
        Log.e((String)"error", (String)Log.getStackTraceString((Throwable)new RuntimeException(message)));
    }

    private SpannableStringBuilder() {
    }

    public static SpannableStringBuilder builder(Context context, String originalStr) {
        return SpannableStringBuilder.builder(context, originalStr, 3);
    }

    public static SpannableStringBuilder builder(Context context, String originalStr, int maxRepeatCount) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        spannableStringBuilder.mCurrentSubStrProperty = new CurrentSubStrProperty(maxRepeatCount);
        spannableStringBuilder.mCurrentSubStrProperty.originalStr = originalStr;
        spannableStringBuilder.mSpannableString = new SpannableString((CharSequence)originalStr);
        spannableStringBuilder.mContext = context.getApplicationContext();
        spannableStringBuilder.setSubStr(originalStr);
        return spannableStringBuilder;
    }

    public SpannableStringBuilder setSubStr(String subStr) {
        this.mCurrentSubStrProperty.reset(subStr);
        return this;
    }

    public SpannableStringBuilder setColorRes(@ColorRes int color) {
        return this.setColorInt(ContextCompat.getColor((Context)this.mContext, (int)color));
    }

    public SpannableStringBuilder setColorInt(@ColorInt int color) {
        for (int i = 0; i < this.mCurrentSubStrProperty.currentRepeatSize; ++i) {
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(color);
            this.mSpannableString.setSpan((Object)foregroundColorSpan, this.mCurrentSubStrProperty.starts[i], this.mCurrentSubStrProperty.ends[i], 34);
        }
        return this;
    }

    public SpannableStringBuilder setIsBold() {
        for (int i = 0; i < this.mCurrentSubStrProperty.currentRepeatSize; ++i) {
            StyleSpan styleSpan = new StyleSpan(1);
            this.mSpannableString.setSpan((Object)styleSpan, this.mCurrentSubStrProperty.starts[i], this.mCurrentSubStrProperty.ends[i], 34);
        }
        return this;
    }

    public SpannableStringBuilder setTextSize(int dp) {
        for (int i = 0; i < this.mCurrentSubStrProperty.currentRepeatSize; ++i) {
            AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan(dp, true);
            this.mSpannableString.setSpan((Object)absoluteSizeSpan, this.mCurrentSubStrProperty.starts[i], this.mCurrentSubStrProperty.ends[i], 34);
        }
        return this;
    }

    public SpannableStringBuilder setCanMovement(TextView textView) {
        this.setMovementMethod(textView);
        return this;
    }

    private void setMovementMethod(TextView textView) {
        if (this.mHasSetMovementMethod) {
            return;
        }
        this.mHasSetMovementMethod = true;
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setHighlightColor(0);
    }

    public SpannableStringBuilder setOnClickListener(OnClickSpanStringListener clickListener) {
        this.mHasSetOnClickListener = true;
        for (int i = 0; i < this.mCurrentSubStrProperty.currentRepeatSize; ++i) {
            BuilderClickableSpan builderClickableSpan = new BuilderClickableSpan();
            builderClickableSpan.mSubString = this.mCurrentSubStrProperty.subStr;
            builderClickableSpan.mOnClickSpanStringListener = clickListener;
            this.mSpannableString.setSpan((Object)builderClickableSpan, this.mCurrentSubStrProperty.starts[i], this.mCurrentSubStrProperty.ends[i], 34);
        }
        return this;
    }

    public SpannableStringBuilder setStrikethrough() {
        for (int i = 0; i < this.mCurrentSubStrProperty.currentRepeatSize; ++i) {
            StrikethroughSpan strikethroughSpan = new StrikethroughSpan();
            this.mSpannableString.setSpan((Object)strikethroughSpan, this.mCurrentSubStrProperty.starts[i], this.mCurrentSubStrProperty.ends[i], 34);
        }
        return this;
    }

    public SpannableStringBuilder setRelativeSize(@FloatRange(from=0.0) float proportion) {
        for (int i = 0; i < this.mCurrentSubStrProperty.currentRepeatSize; ++i) {
            RelativeSizeSpan relativeSizeSpan = new RelativeSizeSpan(proportion);
            this.mSpannableString.setSpan((Object)relativeSizeSpan, this.mCurrentSubStrProperty.starts[i], this.mCurrentSubStrProperty.ends[i], 34);
        }
        return this;
    }

    @CheckResult
    public SpannableString build() {
        return this.mSpannableString;
    }

    public void into(TextView textView) {
        if (textView == null) {
            return;
        }
        if (this.mHasSetOnClickListener) {
            this.setMovementMethod(textView);
        }
        textView.setText((CharSequence)this.mSpannableString);
    }

    public Manual manual() {
        if (this.mManual == null) {
            this.mManual = new Manual(this);
        }
        return this.mManual;
    }

    public static class Manual {
        SpannableStringBuilder mStringBuilder;

        public Manual(SpannableStringBuilder stringBuilder) {
            this.mStringBuilder = stringBuilder;
        }

        public SpannableStringBuilder builder() {
            return this.mStringBuilder;
        }

        @CheckResult
        public SpannableString build() {
            return this.mStringBuilder.mSpannableString;
        }

        public Manual setMovementMethod(TextView textView) {
            this.mStringBuilder.setMovementMethod(textView);
            return this;
        }
    }

    private static class BuilderClickableSpan
    extends ClickableSpan {
        protected String mSubString;
        OnClickSpanStringListener mOnClickSpanStringListener;

        private BuilderClickableSpan() {
        }

        public void onClick(@NonNull View widget) {
            if (this.mOnClickSpanStringListener != null) {
                this.mOnClickSpanStringListener.onClickSpanString(this.mSubString == null ? "" : this.mSubString, widget);
            }
        }

        public void updateDrawState(@NonNull TextPaint ds) {
            ds.setUnderlineText(false);
        }
    }

    public static interface OnClickSpanStringListener {
        public void onClickSpanString(@NonNull String var1, @NonNull View var2);
    }

    private static class CurrentSubStrProperty {
        String originalStr;
        int maxRepeatCount;
        int currentRepeatSize = 0;
        int[] starts;
        int[] ends;
        int length;
        String subStr;

        public CurrentSubStrProperty(int maxRepeatCount) {
            this.maxRepeatCount = maxRepeatCount;
            this.starts = new int[this.maxRepeatCount];
            this.ends = new int[this.maxRepeatCount];
        }

        private void arrayAutoIncrease(int newSize) {
            this.maxRepeatCount = newSize;
            int[] newStarts = new int[this.maxRepeatCount];
            int[] newEnds = new int[this.maxRepeatCount];
            System.arraycopy(this.starts, 0, newStarts, 0, this.starts.length);
            System.arraycopy(this.ends, 0, newEnds, 0, this.ends.length);
            this.starts = newStarts;
            this.ends = newEnds;
        }

        private void reset(String subStr) {
            this.subStr = subStr;
            this.length = subStr.length();
            this.currentRepeatSize = 0;
            int start = 0;
            while ((start = this.originalStr.indexOf(subStr, start)) >= 0) {
                int end = start + this.length;
                if (this.currentRepeatSize >= this.maxRepeatCount) {
                    this.arrayAutoIncrease(this.maxRepeatCount + 10);
                }
                this.starts[this.currentRepeatSize] = start;
                this.ends[this.currentRepeatSize] = end;
                ++this.currentRepeatSize;
                start = end;
            }
        }
    }
}

