/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.recyclerview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;

public class ItemDecorationUtil {
    private static int sDefaultDividerId = -1;

    public static void setDefaultDividerId(@DrawableRes int defaultDividerId) {
        sDefaultDividerId = defaultDividerId;
    }

    public static ItemDecorationUtilHolder setLeftRightSpace(float dp_leftRightSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mLeftRightSpace = dp_leftRightSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setHorizontalCenterSpace(float dp_horizontalCenterSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mHorizontalCenterSpace = dp_horizontalCenterSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setTopSpace(float dp_topSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mTopSpace = dp_topSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setBottomSpace(float dp_bottomSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mBottomSpace = dp_bottomSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setVerticalCenterSpace(float dp_verticalCenterSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mVerticalCenterSpace = dp_verticalCenterSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setShowDividerLine() {
        return ItemDecorationUtil.setShowDividerLine(true);
    }

    public static ItemDecorationUtilHolder setShowDividerLine(boolean showDividerLine) {
        return new ItemDecorationUtilHolder().setShowDividerLine(showDividerLine);
    }

    public ItemDecorationUtilHolder setForceNotDrawAnyFreeze(boolean forceNotDrawAnyFreeze) {
        return new ItemDecorationUtilHolder().setForceNotDrawAnyFreeze(forceNotDrawAnyFreeze);
    }

    public ItemDecorationUtilHolder setAutoResetHolderFreeze(boolean autoResetHolderFreeze) {
        return new ItemDecorationUtilHolder().setAutoResetHolderFreeze(autoResetHolderFreeze);
    }

    public static RecyclerView.ItemDecoration buildDivider() {
        return ItemDecorationUtil.buildDivider(false);
    }

    public static RecyclerView.ItemDecoration buildDivider(boolean showLastDividerLine) {
        return ItemDecorationUtil.setShowDividerLine().setShowLastDividerLine(showLastDividerLine).build();
    }

    public static RecyclerView.ItemDecoration buildDivider(DecorationResetConfig dividerConfig) {
        return ItemDecorationUtil.setShowDividerLine().setDecorationConfig(dividerConfig).build();
    }

    public static RecyclerView.ItemDecoration buildConfig(DecorationResetConfig decorationConfig) {
        return new ItemDecorationUtilHolder().setDecorationConfig(decorationConfig).build();
    }

    private static int dip2px(Context context, float dipValue) {
        if (context == null || dipValue == 0.0f) {
            return 0;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    static /* synthetic */ int access$700() {
        return sDefaultDividerId;
    }

    public static class ItemDecorationUtilHolder {
        private float mLeftRightSpace;
        private float mHorizontalCenterSpace;
        private float mTopSpace;
        private float mBottomSpace;
        private float mVerticalCenterSpace;
        private boolean mTopEqualCenter = false;
        private boolean mBottomEqualCenter = false;
        private DecorationConfig mDecorationConfig;
        private boolean mShowDividerLine = false;
        private boolean mShowLastDividerLine = false;
        private final Rect mBounds = new Rect();
        private Drawable mDivider;
        private boolean mIsForceNotDrawAnyFreeze = true;
        private boolean mIsAutoResetHolderFreeze = true;
        private int mDividerDrawableIdFreeze = ItemDecorationUtil.access$700();

        public final ItemDecorationUtilHolder reset() {
            this.mLeftRightSpace = 0.0f;
            this.mHorizontalCenterSpace = 0.0f;
            this.mTopSpace = 0.0f;
            this.mBottomSpace = 0.0f;
            this.mVerticalCenterSpace = 0.0f;
            this.mTopEqualCenter = false;
            this.mBottomEqualCenter = false;
            this.mShowDividerLine = false;
            this.mShowLastDividerLine = false;
            this.mDivider = null;
            return this;
        }

        @NonNull
        private DecorationConfig getDecorationConfig(@NonNull RecyclerView parent) {
            if (this.mDecorationConfig == null) {
                this.setDecorationConfig(new DefaultDecorationConfig());
            }
            if (this.mDecorationConfig.mContext == null) {
                this.mDecorationConfig.mContext = parent.getContext();
            }
            return this.mDecorationConfig;
        }

        public final ItemDecorationUtilHolder setDecorationConfig(DecorationConfig decorationConfig) {
            if (decorationConfig != null) {
                decorationConfig.setHolder(this);
                this.mDecorationConfig = decorationConfig;
            }
            return this;
        }

        public ItemDecorationUtilHolder setForceNotDrawAnyFreeze(boolean forceNotDrawAnyFreeze) {
            this.mIsForceNotDrawAnyFreeze = forceNotDrawAnyFreeze;
            return this;
        }

        public ItemDecorationUtilHolder setAutoResetHolderFreeze(boolean autoResetHolderFreeze) {
            this.mIsAutoResetHolderFreeze = autoResetHolderFreeze;
            return this;
        }

        public ItemDecorationUtilHolder setDividerDrawableIdFreeze(@DrawableRes int dividerDrawableIdFreeze) {
            this.mDividerDrawableIdFreeze = dividerDrawableIdFreeze;
            return this;
        }

        public ItemDecorationUtilHolder setShowLastDividerLine() {
            return this.setShowLastDividerLine(true);
        }

        public ItemDecorationUtilHolder setShowLastDividerLine(boolean showLastDividerLine) {
            this.mShowLastDividerLine = showLastDividerLine;
            return this;
        }

        public ItemDecorationUtilHolder setShowDividerLine(boolean showDividerLine) {
            if (showDividerLine) {
                this.mIsForceNotDrawAnyFreeze = false;
            }
            this.mShowDividerLine = showDividerLine;
            return this;
        }

        public ItemDecorationUtilHolder setShowDividerLine() {
            return this.setShowDividerLine(true);
        }

        public ItemDecorationUtilHolder setLeftRightSpace(float dp_leftRightSpace) {
            this.mLeftRightSpace = dp_leftRightSpace;
            return this;
        }

        public ItemDecorationUtilHolder setHorizontalCenterSpace(float dp_horizontalCenterSpace) {
            this.mHorizontalCenterSpace = dp_horizontalCenterSpace;
            return this;
        }

        public ItemDecorationUtilHolder setTopSpace(float dp_topSpace) {
            this.mTopSpace = dp_topSpace;
            return this;
        }

        public ItemDecorationUtilHolder setBottomSpace(float dp_bottomSpace) {
            this.mBottomSpace = dp_bottomSpace;
            return this;
        }

        public ItemDecorationUtilHolder setVerticalCenterSpace(float dp_verticalCenterSpace) {
            this.mVerticalCenterSpace = dp_verticalCenterSpace;
            if (this.mTopEqualCenter) {
                this.mTopSpace = this.mVerticalCenterSpace;
            }
            if (this.mBottomEqualCenter) {
                this.mBottomSpace = this.mVerticalCenterSpace;
            }
            return this;
        }

        public ItemDecorationUtilHolder topIsEqualCenter() {
            this.mTopEqualCenter = true;
            this.mTopSpace = this.mVerticalCenterSpace;
            return this;
        }

        public ItemDecorationUtilHolder bottomIsEqualCenter() {
            this.mBottomEqualCenter = true;
            this.mBottomSpace = this.mVerticalCenterSpace;
            return this;
        }

        private ItemDecorationUtilHolder getItemOffsets_LinearLayoutManager(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            boolean isEndRow;
            RecyclerView.Adapter recyclerAdapter = parent.getAdapter();
            Context context = view.getContext();
            if (recyclerAdapter == null || context == null) {
                Log.e((String)"ItemDecorationUtil", (String)"\u65e0\u6cd5\u83b7\u53d6\u5230 Adapter / context ");
                return this;
            }
            int position = parent.getChildAdapterPosition(view);
            int count = recyclerAdapter.getItemCount();
            DecorationConfig decorationConfig = this.getDecorationConfig(parent);
            if (decorationConfig.isAutoResetHolderFreeze()) {
                this.reset();
            }
            if (decorationConfig.resetForGetItemOffsets(this, position, outRect, view, parent, state)) {
                return this;
            }
            if (decorationConfig.hideOffsetAtPosition(position)) {
                return this;
            }
            if (decorationConfig.isShowDividerLine(position)) {
                boolean isEndRow2;
                boolean bl = isEndRow2 = position == count - 1;
                if (isEndRow2 && !decorationConfig.isShowLastDividerLine()) {
                    return this;
                }
                outRect.bottom = decorationConfig.getDividerDrawable(context, position).getIntrinsicHeight();
                return this;
            }
            int leftRightSpace = ItemDecorationUtil.dip2px(context, this.mLeftRightSpace);
            int verticalCenterSpace = ItemDecorationUtil.dip2px(context, this.mVerticalCenterSpace);
            outRect.left = leftRightSpace;
            outRect.right = leftRightSpace;
            boolean isFirstRow = position == 0;
            outRect.top = isFirstRow ? ItemDecorationUtil.dip2px(context, this.mTopSpace) : verticalCenterSpace;
            boolean bl = isEndRow = position == count - 1;
            if (isEndRow) {
                outRect.bottom = ItemDecorationUtil.dip2px(context, this.mBottomSpace);
            }
            return this;
        }

        private ItemDecorationUtilHolder getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                return this.getItemOffsets_GridLayoutManager((GridLayoutManager)layoutManager, outRect, view, parent, state);
            }
            if (layoutManager instanceof LinearLayoutManager) {
                return this.getItemOffsets_LinearLayoutManager(outRect, view, parent, state);
            }
            Log.e((String)"ItemDecorationUtil", (String)("\u975e GridLayoutManager \u6216\u8005 LinearLayoutManager  \uff0c\u4f7f\u7528\u4e86 ItemDecorationUtil -> " + layoutManager));
            return this;
        }

        private void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            int right;
            int left;
            DecorationConfig decorationConfig = this.getDecorationConfig(parent);
            if (decorationConfig.isForceNotDrawAnyFreeze()) {
                return;
            }
            if (parent.getLayoutManager() == null) {
                return;
            }
            canvas.save();
            if (parent.getClipToPadding()) {
                left = parent.getPaddingLeft();
                right = parent.getWidth() - parent.getPaddingRight();
                canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
            } else {
                left = 0;
                right = parent.getWidth();
            }
            int childCount = parent.getChildCount();
            int length = decorationConfig.isShowLastDividerLine() ? childCount : childCount - 1;
            for (int i = 0; i < length; ++i) {
                int position = parent.getChildAdapterPosition(parent.getChildAt(i));
                if (decorationConfig.isAutoResetHolderFreeze()) {
                    this.reset();
                }
                if (decorationConfig.resetForOnDraw(this, position, canvas, parent, state) || decorationConfig.hideOffsetAtPosition(position) || !decorationConfig.isShowDividerLine(position)) continue;
                Drawable dividerDrawable = decorationConfig.getDividerDrawable(parent.getContext(), position);
                View child = parent.getChildAt(i);
                parent.getDecoratedBoundsWithMargins(child, this.mBounds);
                int bottom = this.mBounds.bottom + Math.round(child.getTranslationY());
                int top = bottom - dividerDrawable.getIntrinsicHeight();
                dividerDrawable.setBounds(left, top, right, bottom);
                dividerDrawable.draw(canvas);
            }
            canvas.restore();
        }

        private ItemDecorationUtilHolder getItemOffsets_GridLayoutManager(GridLayoutManager gridLayoutManager, Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            boolean isEndRow;
            RecyclerView.Adapter recyclerAdapter = parent.getAdapter();
            Context context = view.getContext();
            if (recyclerAdapter == null || context == null) {
                Log.e((String)"ItemDecorationUtil", (String)"\u65e0\u6cd5\u83b7\u53d6\u5230 Adapter / context ");
                return this;
            }
            int position = parent.getChildAdapterPosition(view);
            DecorationConfig decorationConfig = this.getDecorationConfig(parent);
            if (decorationConfig.isAutoResetHolderFreeze()) {
                this.reset();
            }
            if (decorationConfig.resetForGetItemOffsets(this, position, outRect, view, parent, state)) {
                return this;
            }
            if (decorationConfig.hideOffsetAtPosition(position)) {
                return this;
            }
            if (decorationConfig.isShowDividerLine(position)) {
                outRect.bottom = decorationConfig.getDividerDrawable(context, position).getIntrinsicHeight();
                return this;
            }
            GridLayoutManager.LayoutParams layoutParams = (GridLayoutManager.LayoutParams)view.getLayoutParams();
            int spanIndex = layoutParams.getSpanIndex();
            int spanSize = layoutParams.getSpanSize();
            int typeColumn = spanIndex / spanSize;
            int prePosition = position - 1 - typeColumn;
            int allSpanCount = gridLayoutManager.getSpanCount();
            int currentSpanSize = 1;
            int preSpanSize = prePosition >= 0 ? 1 : -1;
            int endSpanSize = -1;
            GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
            if (spanSizeLookup != null) {
                currentSpanSize = spanSizeLookup.getSpanSize(position);
                preSpanSize = prePosition >= 0 ? spanSizeLookup.getSpanSize(prePosition) : -1;
            }
            int currentTypeSpanCount = allSpanCount / currentSpanSize;
            if (spanSizeLookup != null) {
                int remainCalculateColumn = currentTypeSpanCount - typeColumn;
                int adapterItemCount = recyclerAdapter.getItemCount();
                for (int i = 1; i <= remainCalculateColumn; ++i) {
                    int endPosition = position + i;
                    if (endPosition < adapterItemCount) {
                        endSpanSize = spanSizeLookup.getSpanSize(endPosition);
                        if (currentSpanSize == endSpanSize) continue;
                        break;
                    }
                    endSpanSize = -1;
                    break;
                }
            }
            float leftRightSpace = ItemDecorationUtil.dip2px(context, this.mLeftRightSpace);
            float horizontalCenterSpace = ItemDecorationUtil.dip2px(context, this.mHorizontalCenterSpace);
            int verticalCenterSpace = ItemDecorationUtil.dip2px(context, this.mVerticalCenterSpace);
            float halfHorizontalCenterSpace = horizontalCenterSpace / 2.0f;
            float leftMoreSpace = leftRightSpace - halfHorizontalCenterSpace;
            float leftRightAppendSpace = leftMoreSpace * 2.0f / (float)currentTypeSpanCount;
            outRect.left = (int)(halfHorizontalCenterSpace + (leftMoreSpace - (float)typeColumn * leftRightAppendSpace));
            outRect.right = (int)(halfHorizontalCenterSpace - (leftMoreSpace - (float)(typeColumn + 1) * leftRightAppendSpace));
            boolean isFirstRow = currentSpanSize != preSpanSize;
            outRect.top = isFirstRow ? ItemDecorationUtil.dip2px(context, this.mTopSpace) : verticalCenterSpace;
            boolean bl = isEndRow = currentSpanSize != endSpanSize;
            if (isEndRow) {
                outRect.bottom = ItemDecorationUtil.dip2px(context, this.mBottomSpace);
            }
            return this;
        }

        public RecyclerView.ItemDecoration build() {
            return new RecyclerView.ItemDecoration(){

                public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                    ItemDecorationUtilHolder.this.getItemOffsets(outRect, view, parent, state);
                }

                public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                    ItemDecorationUtilHolder.this.onDraw(c, parent, state);
                }
            };
        }
    }

    public static class DecorationConfig {
        private ItemDecorationUtilHolder mHolder;
        private Context mContext;

        final DecorationConfig setHolder(ItemDecorationUtilHolder holder) {
            this.mHolder = holder;
            return this;
        }

        protected final ItemDecorationUtilHolder getHolder() {
            return this.mHolder;
        }

        public boolean isForceNotDrawAnyFreeze() {
            return this.mHolder.mIsForceNotDrawAnyFreeze;
        }

        public boolean isAutoResetHolderFreeze() {
            return this.mHolder.mIsAutoResetHolderFreeze;
        }

        public boolean resetForOnDraw(@NonNull ItemDecorationUtilHolder holder, int position, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            return false;
        }

        public boolean resetForGetItemOffsets(@NonNull ItemDecorationUtilHolder holder, int position, @NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            return false;
        }

        @NonNull
        public Drawable getDividerDrawable(Context context, int position) {
            if (this.mHolder.mDivider == null) {
                if (this.getDividerDrawableId(position) != -1) {
                    this.mHolder.mDivider = ContextCompat.getDrawable((Context)context, (int)this.getDividerDrawableId(position));
                }
                if (this.mHolder.mDivider == null) {
                    this.mHolder.mDivider = (Drawable)new ColorDrawable(Color.parseColor((String)"#ebebeb")){

                        public int getIntrinsicHeight() {
                            return 1;
                        }
                    };
                }
            }
            return this.mHolder.mDivider;
        }

        public boolean isShowDividerLine(int position) {
            return this.mHolder.mShowDividerLine;
        }

        public boolean isShowLastDividerLine() {
            return this.mHolder.mShowLastDividerLine;
        }

        public boolean hideOffsetAtPosition(int position) {
            return false;
        }

        @DrawableRes
        public int getDividerDrawableId(int position) {
            return this.mHolder.mDividerDrawableIdFreeze;
        }

        public int dip2px(float dipValue) {
            return ItemDecorationUtil.dip2px(this.mContext, dipValue);
        }

        @Nullable
        public Object getItem(@Nullable List list, int position) {
            if (list == null) {
                return null;
            }
            if (position < 0 || position >= list.size()) {
                return null;
            }
            return list.get(position);
        }
    }

    private static class DefaultDecorationConfig
    extends DecorationConfig {
        private DefaultDecorationConfig() {
        }

        @Override
        public boolean isAutoResetHolderFreeze() {
            return false;
        }
    }

    public static abstract class DecorationResetConfig
    extends DecorationConfig {
        @Override
        public abstract boolean resetForGetItemOffsets(@NonNull ItemDecorationUtilHolder var1, int var2, @NonNull Rect var3, @NonNull View var4, @NonNull RecyclerView var5, @NonNull RecyclerView.State var6);
    }

    public static abstract class DecorationDividerConfig
    extends DecorationResetConfig {
        @Override
        public boolean isShowDividerLine(int position) {
            return true;
        }

        @Override
        public boolean isShowLastDividerLine() {
            return false;
        }

        @Override
        public boolean isForceNotDrawAnyFreeze() {
            return false;
        }

        @Override
        public abstract boolean hideOffsetAtPosition(int var1);

        @Override
        public boolean resetForGetItemOffsets(@NonNull ItemDecorationUtilHolder holder, int position, @NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            return false;
        }
    }
}

