/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;

public class GlideLoadImageUtil {
    public static void loadToWrapContentImageView(ImageView imageView, String picUrl) {
        GlideLoadImageUtil.loadToWrapContentImageView(imageView, picUrl, 0);
    }

    public static void loadToWrapContentImageView(final ImageView imageView, String picUrl, int dp_roundingRadius) {
        if (imageView == null) {
            return;
        }
        RequestBuilder requestBuilder = Glide.with((Context)imageView.getContext()).asBitmap().load(picUrl);
        if (dp_roundingRadius > 0) {
            int px = GlideLoadImageUtil.dip2px(imageView.getContext(), dp_roundingRadius);
            requestBuilder = (RequestBuilder)requestBuilder.transform((Transformation)new RoundedCorners(px));
        }
        requestBuilder.into((Target)new CustomTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
                layoutParams.width = resource.getWidth();
                layoutParams.height = resource.getHeight();
                imageView.setLayoutParams(layoutParams);
                imageView.setImageBitmap(resource);
            }

            public void onLoadCleared(@Nullable Drawable placeholder) {
            }
        });
    }

    private static int dip2px(Context context, float dipValue) {
        if (context == null) {
            return 0;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

