/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.gauss;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zhouwei.blurlibrary.EasyBlur;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import top.ftas.util.size.NavigationBarUtil;

public class GaussBackgroundUtil {
    public static final String GAUSS_BITMAP_CACHE_FILE_NAME = "getGaussBitmapCacheFile.jpg";
    public static final String GAUSS_BITMAP_CACHE_FILE_NAME_ORIGINAL = "getGaussBitmapCacheFile_original.jpg";

    public static Bitmap getGaussBitmapCache(@NonNull Activity activity) {
        String gaussBitmapPath = GaussBackgroundUtil.getGaussBitmapCacheFile(activity);
        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
        bmOptions.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap gaussBitmap = BitmapFactory.decodeFile((String)gaussBitmapPath, (BitmapFactory.Options)bmOptions);
        return gaussBitmap;
    }

    public static String getGaussBitmapCacheFile(Activity activity) {
        return GaussBackgroundUtil.getGaussBitmapCacheFile(activity, false);
    }

    public static String getGaussBitmapCacheFile(Activity activity, boolean forceReset) {
        File file = GaussBackgroundUtil.parseGaussBitmapFilePath((Context)activity, GAUSS_BITMAP_CACHE_FILE_NAME);
        if (file.exists() && !forceReset) {
            return file.getPath();
        }
        if (forceReset) {
            try {
                boolean renameResult;
                File gaussOriginalFile = GaussBackgroundUtil.createAndSaveGaussBitmapToFile(activity, GAUSS_BITMAP_CACHE_FILE_NAME_ORIGINAL);
                if (gaussOriginalFile != null && gaussOriginalFile.exists() && (renameResult = gaussOriginalFile.renameTo(file))) {
                    return file.getPath();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return "";
    }

    public static boolean gaussBitmapCacheFileNotExist(Context context) {
        return !GaussBackgroundUtil.parseGaussBitmapFilePath(context, GAUSS_BITMAP_CACHE_FILE_NAME).exists();
    }

    @Nullable
    public static File createAndSaveGaussBitmapToFile(Activity activity, String fileName) {
        Bitmap bitmap = GaussBackgroundUtil.getGaussBitmap(activity);
        if (bitmap == null) {
            return null;
        }
        File path = GaussBackgroundUtil.saveBitmapToSDCard((Context)activity, bitmap, fileName);
        bitmap.recycle();
        return path;
    }

    public static File parseGaussBitmapFilePath(Context context, String fileName) {
        File dir = context.getExternalCacheDir();
        File file = new File(dir, fileName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveBitmapToSDCard(Context context, Bitmap bitmap, String fileName) {
        File file = GaussBackgroundUtil.parseGaussBitmapFilePath(context, fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static Bitmap getGaussBitmap(Activity activity) {
        try {
            Bitmap bitmap = GaussBackgroundUtil.getScreenCapture(activity);
            Bitmap newBitmap = EasyBlur.with((Context)activity).bitmap(bitmap).radius(10).scale(5).blur();
            return newBitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap getScreenCapture(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        boolean isCacheEnable = decorView.isDrawingCacheEnabled();
        decorView.setDrawingCacheEnabled(true);
        decorView.buildDrawingCache(true);
        Bitmap bitmap = decorView.getDrawingCache();
        int navigationBarHeight = NavigationBarUtil.getNavigationBarHeight((Context)activity);
        Bitmap bmpScreenshot = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)(bitmap.getHeight() - navigationBarHeight));
        decorView.destroyDrawingCache();
        decorView.setDrawingCacheEnabled(isCacheEnable);
        return bmpScreenshot;
    }
}

