/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.bitmap;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import top.ftas.util.R;

public class ShareRedPaperPictureUtil {
    public static String saveBitmapToSDCard(Context context, Bitmap bitmap, String fileName) {
        File dir = context.getExternalCacheDir();
        File file = new File(dir, fileName);
        ShareRedPaperPictureUtil.doSaveBitmapToSdcard(context, bitmap, file);
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSaveBitmapToSdcard(Context context, Bitmap bitmap, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fos);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public static String createRedPaperBitmapAndSave(Context context, ShareRedPaperPictureCreateBean pictureCreateBean) {
        Bitmap bitmap = ShareRedPaperPictureUtil.createRedPaperBitmap(context, pictureCreateBean);
        if (bitmap != null) {
            String picPath = ShareRedPaperPictureUtil.saveRedPaperBitmap(context, bitmap);
            bitmap.recycle();
            return picPath;
        }
        return "";
    }

    @Nullable
    public static String saveRedPaperBitmap(Context context, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return ShareRedPaperPictureUtil.saveBitmapToSDCard(context, bitmap, "share_red_paper_picture.png");
    }

    @Nullable
    public static Bitmap createRedPaperBitmap(Context context, ShareRedPaperPictureCreateBean pictureCreateBean) {
        float miniProgramQrCodeWidth;
        int half_doctorHeight;
        int doctorIconWidth;
        if (pictureCreateBean.doctorIcon == null || pictureCreateBean.miniProgramQrCode == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inMutable = true;
        Bitmap im_bg_share_coupon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.raw.im_bg_share_coupon, (BitmapFactory.Options)options);
        int bgWidth = im_bg_share_coupon.getWidth();
        int half_BgWidth = bgWidth / 2;
        int bgHeight = im_bg_share_coupon.getHeight();
        Canvas canvas = new Canvas(im_bg_share_coupon);
        float scale = (float)canvas.getWidth() / 375.0f;
        Paint paint = new Paint(1);
        int doctorIconHeight = doctorIconWidth = (int)(45.0f * scale);
        int doctorIconRadius = half_doctorHeight = doctorIconHeight / 2;
        int doctorIconLeft = (bgWidth - doctorIconWidth) / 2;
        float doctorIconCenterY = 52.0f * scale;
        float doctorIconTop = doctorIconCenterY - (float)half_doctorHeight;
        Bitmap circleDoctorIcon = ShareRedPaperPictureUtil.circleBitmapByShader(pictureCreateBean.doctorIcon, doctorIconWidth, doctorIconRadius);
        canvas.drawBitmap(circleDoctorIcon, (float)doctorIconLeft, doctorIconTop, paint);
        circleDoctorIcon.recycle();
        if (!TextUtils.isEmpty((CharSequence)pictureCreateBean.topLetter)) {
            ShareRedPaperPictureUtil.setTextRegular(paint);
            ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.CENTER, "#333333", 14.0f * scale);
            Paint.FontMetrics shareMsgFontMetrics = paint.getFontMetrics();
            float shareMsgTextBaseLineY = -shareMsgFontMetrics.top;
            canvas.drawText(pictureCreateBean.topLetter, (float)half_BgWidth, shareMsgTextBaseLineY += doctorIconCenterY + (float)half_doctorHeight + 5.0f * scale, paint);
        }
        ShareRedPaperPictureUtil.setTextSemibold(paint);
        ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#ff5b5b", 29.0f * scale);
        PointF topMoneyPointPointF = new PointF();
        Rect topMoneyPointRect = ShareRedPaperPictureUtil.calculateTextBaseLineY("\uffe5", paint, 28.5f * scale, 34.0f * scale, topMoneyPointPointF);
        topMoneyPointPointF.y += 108.5f * scale;
        ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#ff5b5b", 39.9f * scale);
        PointF base_topMoneyValuePointF = new PointF();
        ShareRedPaperPictureUtil.calculateTextBaseLineY("54", paint, 48.0f * scale, 0.0f, base_topMoneyValuePointF);
        PointF topMoneyValuePointF = new PointF();
        String redPaperMoneyStr = pictureCreateBean.redPaperMoney + "";
        Rect topMoneyValueRect = ShareRedPaperPictureUtil.calculateTextBaseLineY(redPaperMoneyStr, paint, 0.0f, 38.0f * scale, topMoneyValuePointF);
        topMoneyValuePointF.y += 106.5f * scale;
        float topAllTextDisplayWidthNoSpace = topMoneyPointRect.width() + topMoneyValueRect.width();
        float topAllTextSelfSpace = topMoneyPointPointF.x + base_topMoneyValuePointF.x;
        float topAllTextPublicSpace = 5.1f * scale;
        float topAllTextDisplayWidthWithSpace = topAllTextDisplayWidthNoSpace + topAllTextSelfSpace + topAllTextPublicSpace;
        float topLeftTextDisplayX = ((float)bgWidth - topAllTextDisplayWidthWithSpace) / 2.0f;
        float topLeftTextDrawX = topLeftTextDisplayX - topMoneyPointPointF.x;
        float topRightTextDrawX = topLeftTextDisplayX + (float)topMoneyPointRect.width() + topMoneyPointPointF.x + topAllTextPublicSpace;
        ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#ff5b5b", 29.0f * scale);
        canvas.drawText("\uffe5", topLeftTextDrawX, topMoneyPointPointF.y, paint);
        ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#ff5b5b", 39.9f * scale);
        canvas.drawText(redPaperMoneyStr, topRightTextDrawX, topMoneyValuePointF.y, paint);
        canvas.translate(0.0f, (float)bgHeight);
        ShareRedPaperPictureUtil.setTextSemibold(paint);
        float bottomMoneyStrLeft = 15.0f * scale;
        float bottomMoneyStrUseWidth = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)pictureCreateBean.bottomEm)) {
            String bottomMoneyStr = pictureCreateBean.bottomEm;
            ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#ff5b5b", 25.0f * scale);
            ShareRedPaperPictureUtil.drawBottomText(canvas, paint, bottomMoneyStrLeft, 53.0f * scale, bottomMoneyStr);
            bottomMoneyStrUseWidth = paint.measureText(bottomMoneyStr);
        }
        if (!TextUtils.isEmpty((CharSequence)pictureCreateBean.bottomTitle)) {
            ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#333333", 18.0f * scale);
            float bottomMoneyEndStrLeft = bottomMoneyStrLeft + bottomMoneyStrUseWidth + 2.0f * scale;
            ShareRedPaperPictureUtil.drawBottomText(canvas, paint, bottomMoneyEndStrLeft, 54.0f * scale, pictureCreateBean.bottomTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)pictureCreateBean.bottomSubTitle)) {
            ShareRedPaperPictureUtil.setTextRegular(paint);
            ShareRedPaperPictureUtil.resetPaintTextStyle(paint, Paint.Align.LEFT, "#999999", 12.0f * scale);
            ShareRedPaperPictureUtil.drawBottomText(canvas, paint, 15.0f * scale, 31.0f * scale, pictureCreateBean.bottomSubTitle);
        }
        float miniProgramQrCodeHeight = miniProgramQrCodeWidth = 80.0f * scale;
        float miniProgramQrCodeLeft = (float)bgWidth - 15.0f * scale - miniProgramQrCodeWidth;
        float miniProgramQrCodeTop = -10.0f * scale - miniProgramQrCodeHeight;
        float translateMiniProgramQrCodeDx = (float)bgWidth - miniProgramQrCodeWidth - 15.0f * scale;
        float translateMiniProgramQrCodeDy = -miniProgramQrCodeHeight - 10.0f * scale;
        canvas.translate(translateMiniProgramQrCodeDx, translateMiniProgramQrCodeDy);
        Matrix miniProgramQrCodeMatrix = ShareRedPaperPictureUtil.zoomImgMatrix(pictureCreateBean.miniProgramQrCode, miniProgramQrCodeWidth, miniProgramQrCodeHeight);
        canvas.drawBitmap(pictureCreateBean.miniProgramQrCode, miniProgramQrCodeMatrix, paint);
        return im_bg_share_coupon;
    }

    public static void setTextSemibold(Paint paint) {
        paint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
    }

    public static void setTextRegular(Paint paint) {
        paint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
    }

    public static Rect calculateTextBaseLineY(String str, Paint paint, float textViewFullWidth, float textViewFullHeight, PointF pointF) {
        Rect topMoneyValueTextBounds = new Rect();
        paint.getTextBounds(str, 0, str.length(), topMoneyValueTextBounds);
        float topMoneyValueTextDisplayHeight = topMoneyValueTextBounds.height();
        float textDisplayWidth = topMoneyValueTextBounds.width();
        float half_vertical_TextSpace = (textViewFullHeight - topMoneyValueTextDisplayHeight) / 2.0f;
        float half_horizontal_TextSpace = (textViewFullWidth - textDisplayWidth) / 2.0f;
        pointF.y = topMoneyValueTextDisplayHeight + half_vertical_TextSpace;
        pointF.x = half_horizontal_TextSpace;
        return topMoneyValueTextBounds;
    }

    public static Matrix zoomImgMatrix(Bitmap bm, float newWidth, float newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = newWidth / (float)width;
        float scaleHeight = newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return matrix;
    }

    public static Bitmap circleBitmapByShader(Bitmap bitmap, int edgeWidth, int radius) {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap can't be null");
        }
        float btWidth = bitmap.getWidth();
        float btHeight = bitmap.getHeight();
        float btWidthCutSite = 0.0f;
        float btHeightCutSite = 0.0f;
        float squareWidth = 0.0f;
        if (btWidth > btHeight) {
            btWidthCutSite = (btWidth - btHeight) / 2.0f;
            squareWidth = btHeight;
        } else {
            btHeightCutSite = (btHeight - btWidth) / 2.0f;
            squareWidth = btWidth;
        }
        float scale = (float)edgeWidth * 1.0f / squareWidth;
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale);
        Bitmap squareBt = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)btWidthCutSite), (int)((int)btHeightCutSite), (int)((int)squareWidth), (int)((int)squareWidth), (Matrix)matrix, (boolean)true);
        BitmapShader bitmapShader = new BitmapShader(squareBt, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Bitmap targetBitmap = Bitmap.createBitmap((int)edgeWidth, (int)edgeWidth, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas targetCanvas = new Canvas(targetBitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        targetCanvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)edgeWidth, (float)edgeWidth), (float)radius, (float)radius, paint);
        return targetBitmap;
    }

    public static Bitmap zoomImg(Bitmap bm, float newWidth, float newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = newWidth / (float)width;
        float scaleHeight = newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newBitmap;
    }

    public static void drawBottomText(Canvas canvas, Paint paint, float left, float bottom, String strMsg) {
        Paint.FontMetrics paintFontMetrics = paint.getFontMetrics();
        float baseLineY = -paintFontMetrics.bottom;
        canvas.drawText(strMsg, left, baseLineY -= bottom, paint);
    }

    public static void drawBottomTextUseFontMetrics(Canvas canvas, Paint paint, float scale, float dp_left, float dp_bottom, String strMsg) {
        Paint.FontMetrics paintFontMetrics = paint.getFontMetrics();
        float baseLineY = -paintFontMetrics.bottom;
        canvas.drawText(strMsg, dp_left *= scale, baseLineY -= (dp_bottom *= scale), paint);
    }

    public static void resetPaintTextStyle(Paint paint, Paint.Align align, String colorString, float textSize) {
        paint.setTextAlign(align);
        paint.setColor(Color.parseColor((String)colorString));
        paint.setTextSize(textSize);
    }

    public static class ShareRedPaperPictureCreateBean {
        public int redPaperMoney = 0;
        public Bitmap doctorIcon;
        public Bitmap miniProgramQrCode;
        public String topLetter;
        public String bottomEm;
        public String bottomTitle;
        public String bottomSubTitle;

        public void recycle() {
            if (this.doctorIcon != null && !this.doctorIcon.isRecycled()) {
                this.doctorIcon.recycle();
            }
            if (this.miniProgramQrCode != null && !this.miniProgramQrCode.isRecycled()) {
                this.miniProgramQrCode.recycle();
            }
        }
    }
}

