/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import java.io.IOException;
import java.io.InputStream;

public class LoadBitmapFromViewUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Bitmap loadBitmapFromRawResource(@NonNull Context context, @RawRes int id2) {
        InputStream inputStream = null;
        try {
            Bitmap rawBitmap;
            inputStream = context.getResources().openRawResource(id2);
            Bitmap bitmap = rawBitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Bitmap loadBitmapAndCloseStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static View loadView(Context context, int viewResId) {
        if (context == null || viewResId <= 0) {
            return null;
        }
        FrameLayout frameLayout = new FrameLayout(context);
        View view = LayoutInflater.from((Context)context).inflate(viewResId, (ViewGroup)frameLayout, false);
        return view;
    }

    public static Bitmap loadBitmap(Context context, int viewResId) {
        if (context == null || viewResId <= 0) {
            return null;
        }
        return LoadBitmapFromViewUtil.loadBitmap(LoadBitmapFromViewUtil.loadView(context, viewResId));
    }

    public static Bitmap loadBitmap(View view) {
        if (view == null) {
            return null;
        }
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }
}

