/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.window_statusbar;

import android.app.ActionBar;
import android.app.Activity;
import android.app.Dialog;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

public class WindowUtil {
    public static void beforeSetContentViewSetToDark(Activity activity) {
        try {
            ActionBar actionBar;
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1024);
            if (Build.VERSION.SDK_INT >= 21) {
                window.setStatusBarColor(0);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                View decorView = window.getDecorView();
                decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | 0x2000);
            }
            if (activity instanceof AppCompatActivity) {
                actionBar = ((AppCompatActivity)activity).getSupportActionBar();
                if (actionBar != null) {
                    actionBar.hide();
                }
            } else {
                actionBar = activity.getActionBar();
                if (actionBar != null) {
                    actionBar.hide();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setActivityToFullScreen(Activity activity) {
        WindowUtil.setActivityToFullScreen(activity, false, false);
    }

    public static void setActivityToFullScreenWithInvisibleStatusBar(Activity activity) {
        WindowUtil.setActivityToFullScreen(activity, true, true);
    }

    public static void showActivityStatusBar(Activity activity) {
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        window.getDecorView().setSystemUiVisibility(0);
        ViewGroup contentLayout = (ViewGroup)activity.findViewById(0x1020002);
        if (contentLayout == null || contentLayout.getChildCount() <= 0) {
            return;
        }
        contentLayout.getChildAt(0).setFitsSystemWindows(true);
    }

    public static void showActionBar(Activity activity) {
        if (activity instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionBar = ((AppCompatActivity)activity).getSupportActionBar();
            if (actionBar != null) {
                actionBar.show();
            }
        } else {
            ActionBar actionBar = activity.getActionBar();
            if (actionBar != null) {
                actionBar.show();
            }
        }
    }

    public static void setActivityToFullScreen(Activity activity, boolean hideActionBar, boolean statusBarIsInvisible) {
        Window window;
        if (activity == null) {
            return;
        }
        if (hideActionBar) {
            ActionBar actionBar;
            if (activity instanceof AppCompatActivity) {
                actionBar = ((AppCompatActivity)activity).getSupportActionBar();
                if (actionBar != null) {
                    actionBar.hide();
                }
            } else {
                actionBar = activity.getActionBar();
                if (actionBar != null) {
                    actionBar.hide();
                }
            }
        }
        if ((window = activity.getWindow()) == null) {
            return;
        }
        if (statusBarIsInvisible) {
            window.getDecorView().setSystemUiVisibility(4);
        } else {
            window.getDecorView().setSystemUiVisibility(1280);
        }
        ViewGroup contentLayout = (ViewGroup)activity.findViewById(0x1020002);
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(0);
        }
        if (contentLayout == null || contentLayout.getChildCount() <= 0) {
            return;
        }
        contentLayout.getChildAt(0).setFitsSystemWindows(false);
    }

    public static void setSupportDialogFragmentToTransparent(DialogFragment dialogFragment) {
        Dialog dialog = dialogFragment.getDialog();
        if (dialog == null) {
            return;
        }
        Window window = dialog.getWindow();
        WindowManager.LayoutParams windowParams = window.getAttributes();
        windowParams.dimAmount = 0.0f;
        window.setAttributes(windowParams);
        window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
    }
}

