/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.softinput;

import android.app.Activity;
import android.content.Context;
import android.os.IBinder;
import android.text.method.KeyListener;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import top.ftas.util.touch.TouchEventUtil;

public class SoftInputUtil {
    public static void showSoftInput(Activity activity, EditText edit) {
        SoftInputUtil.showSoftInput(activity, edit, true);
    }

    public static void showSoftInput(Activity activity, EditText edit, boolean toTail) {
        String txtString;
        Object obj = edit.getTag();
        if (obj instanceof KeyListener) {
            edit.setKeyListener((KeyListener)obj);
        }
        if (toTail && (txtString = edit.getText().toString()) != null) {
            edit.setSelection(txtString.length());
        }
        edit.requestFocus();
        activity.getWindow().setSoftInputMode(4);
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        imm.showSoftInput((View)edit, 2);
    }

    public static void hideSoftInputIfNeed(Context context, View view, MotionEvent ev) {
        if (SoftInputUtil.needHideInput(view, ev)) {
            SoftInputUtil.hideDirectly(context);
        }
    }

    public static boolean needHideInput(View v, MotionEvent ev) {
        return !TouchEventUtil.isTouchPointInView(v, (int)ev.getRawX(), (int)ev.getRawY());
    }

    public static void hideSoftInput(Activity activity) {
        try {
            InputMethodManager manager = (InputMethodManager)activity.getSystemService("input_method");
            IBinder binder = activity.getCurrentFocus().getWindowToken();
            if (binder != null) {
                manager.hideSoftInputFromWindow(binder, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void hideDirectly(Context context) {
        if (context instanceof Activity) {
            SoftInputUtil.hideSoftInput((Activity)context);
        } else {
            SoftInputUtil.hideWithContext(context);
        }
    }

    public static void hideWithContext(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        inputMethodManager.toggleSoftInput(0, 2);
    }

    public static boolean isShowSoftInput(Context context, View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        return imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }
}

