/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.size;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import top.ftas.util.softinput.SoftInputUtil;

public class ViewPreparedUtil {
    public static void addViewPreparedListener(View view, OnViewPreparedListener onViewPreparedListener) {
        onViewPreparedListener.setView(view);
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)onViewPreparedListener);
    }

    public static void measureView(View view) {
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int height = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(width, height);
    }

    public static abstract class OnViewPreparedListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private int layoutCount;
        private boolean requiredSoftInputHidden;
        private WeakReference<View> mViewWeakReference;

        public View getView() {
            return (View)this.mViewWeakReference.get();
        }

        public void setView(View view) {
            this.mViewWeakReference = new WeakReference<View>(view);
        }

        public OnViewPreparedListener() {
        }

        public OnViewPreparedListener(boolean requiredSoftInputHidden) {
            this.requiredSoftInputHidden = requiredSoftInputHidden;
        }

        public int getLayoutCount() {
            return this.layoutCount;
        }

        public void setLayoutCount(int layoutCount) {
            this.layoutCount = layoutCount;
        }

        public boolean isRequiredSoftInputHidden() {
            return this.requiredSoftInputHidden;
        }

        public void setRequiredSoftInputHidden(boolean requiredSoftInputHidden) {
            this.requiredSoftInputHidden = requiredSoftInputHidden;
        }

        public void onGlobalLayout() {
            View view = (View)this.mViewWeakReference.get();
            if (view == null) {
                return;
            }
            ++this.layoutCount;
            this.onPrepared(view, this.layoutCount);
        }

        public abstract void onFirstPrepared(View var1);

        public void onPrepared(View view, int layoutCount) {
            if (this.isRequiredSoftInputHidden()) {
                Context context = view.getContext();
                if (SoftInputUtil.isShowSoftInput(context, view)) {
                    SoftInputUtil.hideDirectly(context);
                    this.setLayoutCount(0);
                    return;
                }
                this.removeSelf(view, layoutCount);
            } else {
                this.removeSelf(view, layoutCount);
            }
            if (layoutCount == 1) {
                this.onFirstPrepared(view);
            }
        }

        public void removeSelf(View view, int layoutCount) {
            if (Build.VERSION.SDK_INT >= 16) {
                view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }
}

