/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.size;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.ViewConfiguration;
import java.lang.reflect.Method;

public class NavigationBarUtil {
    public static int getNavigationBarHeight(Context context) {
        Resources res;
        int resourceId;
        int result = 0;
        if (NavigationBarUtil.hasNavBar(context) && (resourceId = (res = context.getResources()).getIdentifier("navigation_bar_height", "dimen", "android")) > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @TargetApi(value=14)
    public static boolean hasNavBar(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            String sNavBarOverride = NavigationBarUtil.getNavBarOverride();
            if ("1".equals(sNavBarOverride)) {
                hasNav = false;
            } else if ("0".equals(sNavBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sNavBarOverride;
    }
}

