/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.recyclerview;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;

public class ItemDecorationUtil {
    public static ItemDecorationUtilHolder sItemDecorationUtil;

    public static ItemDecorationUtilHolder reset() {
        if (sItemDecorationUtil == null) {
            sItemDecorationUtil = new ItemDecorationUtilHolder();
        }
        sItemDecorationUtil.mLeftRightSpace = 0.0f;
        sItemDecorationUtil.mHorizontalCenterSpace = 0.0f;
        sItemDecorationUtil.mTopSpace = 0.0f;
        sItemDecorationUtil.mBottomSpace = 0.0f;
        sItemDecorationUtil.mVerticalCenterSpace = 0.0f;
        sItemDecorationUtil.mTopEqualCenter = false;
        sItemDecorationUtil.mBottomEqualCenter = false;
        return sItemDecorationUtil;
    }

    public static ItemDecorationUtilHolder setLeftRightSpace(float dp_leftRightSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mLeftRightSpace = dp_leftRightSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setHorizontalCenterSpace(float dp_horizontalCenterSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mHorizontalCenterSpace = dp_horizontalCenterSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setTopSpace(float dp_topSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mTopSpace = dp_topSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setBottomSpace(float dp_bottomSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mBottomSpace = dp_bottomSpace;
        return itemDecorationUtilHolder;
    }

    public static ItemDecorationUtilHolder setVerticalCenterSpace(float dp_verticalCenterSpace) {
        ItemDecorationUtilHolder itemDecorationUtilHolder = new ItemDecorationUtilHolder();
        itemDecorationUtilHolder.mVerticalCenterSpace = dp_verticalCenterSpace;
        return itemDecorationUtilHolder;
    }

    private static int dip2px(Context context, float dipValue) {
        if (context == null || dipValue == 0.0f) {
            return 0;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static class ItemDecorationUtilHolder {
        private float mLeftRightSpace;
        private float mHorizontalCenterSpace;
        private float mTopSpace;
        private float mBottomSpace;
        private float mVerticalCenterSpace;
        private boolean mTopEqualCenter = false;
        private boolean mBottomEqualCenter = false;

        public ItemDecorationUtilHolder setLeftRightSpace(float dp_leftRightSpace) {
            this.mLeftRightSpace = dp_leftRightSpace;
            return this;
        }

        public ItemDecorationUtilHolder setHorizontalCenterSpace(float dp_horizontalCenterSpace) {
            this.mHorizontalCenterSpace = dp_horizontalCenterSpace;
            return this;
        }

        public ItemDecorationUtilHolder setTopSpace(float dp_topSpace) {
            this.mTopSpace = dp_topSpace;
            return this;
        }

        public ItemDecorationUtilHolder setBottomSpace(float dp_bottomSpace) {
            this.mBottomSpace = dp_bottomSpace;
            return this;
        }

        public ItemDecorationUtilHolder setVerticalCenterSpace(float dp_verticalCenterSpace) {
            this.mVerticalCenterSpace = dp_verticalCenterSpace;
            if (this.mTopEqualCenter) {
                this.mTopSpace = this.mVerticalCenterSpace;
            }
            if (this.mBottomEqualCenter) {
                this.mBottomSpace = this.mVerticalCenterSpace;
            }
            return this;
        }

        public ItemDecorationUtilHolder topIsEqualCenter() {
            this.mTopEqualCenter = true;
            this.mTopSpace = this.mVerticalCenterSpace;
            return this;
        }

        public ItemDecorationUtilHolder bottomIsEqualCenter() {
            this.mBottomEqualCenter = true;
            this.mBottomSpace = this.mVerticalCenterSpace;
            return this;
        }

        private ItemDecorationUtilHolder getItemOffsets_LinearLayoutManager(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            boolean isEndRow;
            RecyclerView.Adapter recyclerAdapter = parent.getAdapter();
            Context context = view.getContext();
            if (recyclerAdapter == null || context == null) {
                Log.e((String)"ItemDecorationUtil", (String)"\u65e0\u6cd5\u83b7\u53d6\u5230 Adapter / context ");
                return this;
            }
            int position = parent.getChildAdapterPosition(view);
            int count = recyclerAdapter.getItemCount();
            int leftRightSpace = ItemDecorationUtil.dip2px(context, this.mLeftRightSpace);
            int verticalCenterSpace = ItemDecorationUtil.dip2px(context, this.mVerticalCenterSpace);
            outRect.left = leftRightSpace;
            outRect.right = leftRightSpace;
            boolean isFirstRow = position == 0;
            outRect.top = isFirstRow ? ItemDecorationUtil.dip2px(context, this.mTopSpace) : verticalCenterSpace;
            boolean bl = isEndRow = position == count - 1;
            if (isEndRow) {
                outRect.bottom = ItemDecorationUtil.dip2px(context, this.mBottomSpace);
            }
            return this;
        }

        public ItemDecorationUtilHolder getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
            if (layoutManager == null) {
                return this;
            }
            if (layoutManager instanceof GridLayoutManager) {
                return this.getItemOffsets_GridLayoutManager(outRect, view, parent, state);
            }
            if (layoutManager instanceof LinearLayoutManager) {
                return this.getItemOffsets_LinearLayoutManager(outRect, view, parent, state);
            }
            Log.e((String)"ItemDecorationUtil", (String)"\u975e GridLayoutManager \uff0c\u4f7f\u7528\u4e86 ItemDecorationUtil");
            return this;
        }

        private ItemDecorationUtilHolder getItemOffsets_GridLayoutManager(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            boolean isEndRow;
            RecyclerView.Adapter recyclerAdapter = parent.getAdapter();
            Context context = view.getContext();
            if (recyclerAdapter == null || context == null) {
                Log.e((String)"ItemDecorationUtil", (String)"\u65e0\u6cd5\u83b7\u53d6\u5230 Adapter / context ");
                return this;
            }
            int position = parent.getChildAdapterPosition(view);
            GridLayoutManager gridLayoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.LayoutParams layoutParams = (GridLayoutManager.LayoutParams)view.getLayoutParams();
            int spanIndex = layoutParams.getSpanIndex();
            int spanSize = layoutParams.getSpanSize();
            int typeColumn = spanIndex / spanSize;
            int prePosition = position - 1 - typeColumn;
            int allSpanCount = gridLayoutManager.getSpanCount();
            int currentSpanSize = 1;
            int preSpanSize = prePosition >= 0 ? 1 : -1;
            int endSpanSize = -1;
            GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
            if (spanSizeLookup != null) {
                currentSpanSize = spanSizeLookup.getSpanSize(position);
                preSpanSize = prePosition >= 0 ? spanSizeLookup.getSpanSize(prePosition) : -1;
            }
            int currentTypeSpanCount = allSpanCount / currentSpanSize;
            if (spanSizeLookup != null) {
                int remainCalculateColumn = currentTypeSpanCount - typeColumn;
                int adapterItemCount = recyclerAdapter.getItemCount();
                for (int i = 1; i <= remainCalculateColumn; ++i) {
                    int endPosition = position + i;
                    if (endPosition < adapterItemCount) {
                        endSpanSize = spanSizeLookup.getSpanSize(endPosition);
                        if (currentSpanSize == endSpanSize) continue;
                        break;
                    }
                    endSpanSize = -1;
                    break;
                }
            }
            int leftRightSpace = ItemDecorationUtil.dip2px(context, this.mLeftRightSpace);
            int horizontalCenterSpace = ItemDecorationUtil.dip2px(context, this.mHorizontalCenterSpace);
            int verticalCenterSpace = ItemDecorationUtil.dip2px(context, this.mVerticalCenterSpace);
            int allSpace = (currentTypeSpanCount - 1) * horizontalCenterSpace;
            int averageSpace = allSpace / currentTypeSpanCount;
            int halfHorizontalCenterSpace = horizontalCenterSpace / 2;
            int leftRightAppendSpace = horizontalCenterSpace - averageSpace;
            int endColumnIndex = currentTypeSpanCount - 1;
            if (typeColumn == 0) {
                outRect.left = leftRightSpace;
                outRect.right = averageSpace;
            } else if (typeColumn == endColumnIndex) {
                outRect.right = leftRightSpace;
                outRect.left = averageSpace;
            } else {
                outRect.left = halfHorizontalCenterSpace;
                outRect.right = halfHorizontalCenterSpace;
                if (typeColumn == 1) {
                    outRect.left = leftRightAppendSpace;
                }
                if (typeColumn == endColumnIndex - 1) {
                    outRect.right = leftRightAppendSpace;
                }
            }
            boolean isFirstRow = currentSpanSize != preSpanSize;
            outRect.top = isFirstRow ? ItemDecorationUtil.dip2px(context, this.mTopSpace) : verticalCenterSpace;
            boolean bl = isEndRow = currentSpanSize != endSpanSize;
            if (isEndRow) {
                outRect.bottom = ItemDecorationUtil.dip2px(context, this.mBottomSpace);
            }
            return this;
        }

        public RecyclerView.ItemDecoration build() {
            return new RecyclerView.ItemDecoration(){

                public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                    ItemDecorationUtilHolder.this.getItemOffsets(outRect, view, parent, state);
                }
            };
        }
    }
}

