/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.drawable;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;

public class DrawableToBitmapUtil {
    public static Bitmap drawableToBitmap(Context context, int drawableId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return DrawableToBitmapUtil.drawableToBitmap(drawable, 1, 1);
    }

    public static Bitmap drawableToBitmap(Context context, int drawableId, int bitmapWidth, int bitmapHeight) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return DrawableToBitmapUtil.drawableToBitmap(drawable, bitmapWidth, bitmapHeight);
    }

    public static Bitmap drawableToBitmap(Drawable drawable, int bitmapWidth, int bitmapHeight) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }
}

