/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.window_statusbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class StatusBarUtil {
    public static void setStatusBarColor(Activity activity, int resColor, boolean isDarkText) {
        if (activity == null || resColor <= 0) {
            return;
        }
        int colorValue = ContextCompat.getColor((Context)activity, (int)resColor);
        StatusBarUtil.setStatusBarColorWithColorValue(activity, colorValue, isDarkText);
    }

    public static void setStatusBarColorWithColorValue(Activity activity, int colorValue, boolean isDarkText) {
        View view;
        if (activity == null) {
            return;
        }
        if (FlymeUtils.isFlyme() || MIUIUtils.isMIUI()) {
            if (FlymeUtils.isFlyme()) {
                StatusBarUtil.FlymeSetStatusBarLightMode(activity.getWindow(), isDarkText);
            } else {
                StatusBarUtil.MIUISetStatusBarLightMode(activity.getWindow(), isDarkText);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(colorValue);
        }
        if (Build.VERSION.SDK_INT >= 23 && (view = activity.findViewById(0x1020002)) != null) {
            view.setSystemUiVisibility(colorValue == -1 ? 8192 : 0);
        }
    }

    public static boolean FlymeSetStatusBarLightMode(Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean MIUISetStatusBarLightMode(Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                int darkModeFlag = 0;
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static class BuildProperties {
        private final Properties properties = new Properties();

        private BuildProperties() throws IOException {
            this.properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
        }

        public boolean containsKey(Object key) {
            return this.properties.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.properties.containsValue(value);
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.properties.entrySet();
        }

        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public String getProperty(String name, String defaultValue) {
            return this.properties.getProperty(name, defaultValue);
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public Enumeration<Object> keys() {
            return this.properties.keys();
        }

        public Set<Object> keySet() {
            return this.properties.keySet();
        }

        public int size() {
            return this.properties.size();
        }

        public Collection<Object> values() {
            return this.properties.values();
        }

        public static BuildProperties newInstance() throws IOException {
            return new BuildProperties();
        }
    }

    public static class FlymeUtils {
        public static boolean isFlyme() {
            try {
                Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
                return method != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class MIUIUtils {
        private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
        private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
        private static final String KEY_MIUI_INTERNAL_STORAGE = "ro.miui.internal.storage";

        public static boolean isMIUI() {
            if (Build.VERSION.SDK_INT < 26) {
                try {
                    BuildProperties prop = BuildProperties.newInstance();
                    return prop.getProperty(KEY_MIUI_VERSION_CODE, null) != null || prop.getProperty(KEY_MIUI_VERSION_NAME, null) != null || prop.getProperty(KEY_MIUI_INTERNAL_STORAGE, null) != null;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    }
}

