/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.string;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.view.View;

public class SpannableStringBuilder {
    public final String TAG = "SpannableStringBuilder";
    String mOriginalStr;
    SpannableString mSpannableString;
    CurrentSubStrProperty mCurrentSubStrProperty = new CurrentSubStrProperty();
    private Context mContext;

    private SpannableStringBuilder() {
    }

    public static SpannableStringBuilder builder(Context context, String originalStr) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        spannableStringBuilder.mOriginalStr = originalStr;
        spannableStringBuilder.mSpannableString = new SpannableString((CharSequence)originalStr);
        spannableStringBuilder.mContext = context instanceof Activity ? context.getApplicationContext() : context;
        return spannableStringBuilder;
    }

    public SpannableStringBuilder setSubStr(String subStr) {
        this.mCurrentSubStrProperty.reset(subStr);
        return this;
    }

    public SpannableStringBuilder setColorRes(@ColorRes int color) {
        return this.setColorInt(ContextCompat.getColor((Context)this.mContext, (int)color));
    }

    public SpannableStringBuilder setColorInt(@ColorInt int color) {
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(color);
        this.mSpannableString.setSpan((Object)foregroundColorSpan, this.mCurrentSubStrProperty.start, this.mCurrentSubStrProperty.end, 34);
        return this;
    }

    public SpannableStringBuilder setIsBold() {
        StyleSpan styleSpan = new StyleSpan(1);
        this.mSpannableString.setSpan((Object)styleSpan, this.mCurrentSubStrProperty.start, this.mCurrentSubStrProperty.end, 34);
        return this;
    }

    public SpannableStringBuilder setTextSize(int dp) {
        AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan(dp, true);
        this.mSpannableString.setSpan((Object)absoluteSizeSpan, this.mCurrentSubStrProperty.start, this.mCurrentSubStrProperty.end, 34);
        return this;
    }

    public SpannableStringBuilder setOnClickListener(final View.OnClickListener onClickListener) {
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(@NonNull View widget) {
                if (onClickListener != null) {
                    onClickListener.onClick(widget);
                }
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                ds.setUnderlineText(false);
            }
        };
        this.mSpannableString.setSpan((Object)clickableSpan, this.mCurrentSubStrProperty.start, this.mCurrentSubStrProperty.end, 34);
        return this;
    }

    public SpannableStringBuilder setStrikethrough() {
        StrikethroughSpan strikethroughSpan = new StrikethroughSpan();
        this.mSpannableString.setSpan((Object)strikethroughSpan, this.mCurrentSubStrProperty.start, this.mCurrentSubStrProperty.end, 34);
        return this;
    }

    public SpannableStringBuilder setRelativeSize(@FloatRange(from=0.0) float proportion) {
        RelativeSizeSpan relativeSizeSpan = new RelativeSizeSpan(proportion);
        this.mSpannableString.setSpan((Object)relativeSizeSpan, this.mCurrentSubStrProperty.start, this.mCurrentSubStrProperty.end, 34);
        return this;
    }

    public SpannableString build() {
        return this.mSpannableString;
    }

    private class CurrentSubStrProperty {
        int start;
        int end;
        int length;
        String subStr;

        private CurrentSubStrProperty() {
        }

        private void reset(String subStr) {
            this.subStr = subStr;
            this.length = subStr.length();
            this.start = SpannableStringBuilder.this.mOriginalStr.indexOf(subStr);
            this.end = this.start + this.length;
        }
    }
}

