/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util.recyclerview;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;

public class ItemDecorationUtil {
    public static ItemDecorationUtil sItemDecorationUtil = new ItemDecorationUtil();
    private int mLeftRightSpace;
    private int mHorizontalCenterSpace;
    private int mTopSpace;
    private int mBottomSpace;
    private int mVerticalCenterSpace;

    public ItemDecorationUtil setLeftRightSpace(int leftRightSpace) {
        ItemDecorationUtil.sItemDecorationUtil.mLeftRightSpace = leftRightSpace;
        return sItemDecorationUtil;
    }

    public ItemDecorationUtil setHorizontalCenterSpace(int horizontalCenterSpace) {
        ItemDecorationUtil.sItemDecorationUtil.mHorizontalCenterSpace = horizontalCenterSpace;
        return sItemDecorationUtil;
    }

    public ItemDecorationUtil setTopSpace(int topSpace) {
        ItemDecorationUtil.sItemDecorationUtil.mTopSpace = topSpace;
        return sItemDecorationUtil;
    }

    public ItemDecorationUtil setBottomSpace(int bottomSpace) {
        ItemDecorationUtil.sItemDecorationUtil.mBottomSpace = bottomSpace;
        return sItemDecorationUtil;
    }

    public ItemDecorationUtil setVerticalCenterSpace(int verticalCenterSpace) {
        ItemDecorationUtil.sItemDecorationUtil.mVerticalCenterSpace = verticalCenterSpace;
        return sItemDecorationUtil;
    }

    public static ItemDecorationUtil reset() {
        ItemDecorationUtil.sItemDecorationUtil.mLeftRightSpace = 0;
        ItemDecorationUtil.sItemDecorationUtil.mHorizontalCenterSpace = 0;
        ItemDecorationUtil.sItemDecorationUtil.mTopSpace = 0;
        ItemDecorationUtil.sItemDecorationUtil.mBottomSpace = 0;
        ItemDecorationUtil.sItemDecorationUtil.mVerticalCenterSpace = 0;
        return sItemDecorationUtil;
    }

    public ItemDecorationUtil getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        boolean isEndRow;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null || !(layoutManager instanceof GridLayoutManager)) {
            Log.e((String)"ItemDecorationUtil", (String)"\u975e GridLayoutManager \uff0c\u4f7f\u7528\u4e86 ItemDecorationUtil");
            return sItemDecorationUtil;
        }
        RecyclerView.Adapter recyclerAdapter = parent.getAdapter();
        if (recyclerAdapter == null) {
            Log.e((String)"ItemDecorationUtil", (String)"\u65e0\u6cd5\u83b7\u53d6\u5230 Adapter ");
            return sItemDecorationUtil;
        }
        int position = parent.getChildAdapterPosition(view);
        GridLayoutManager gridLayoutManager = (GridLayoutManager)parent.getLayoutManager();
        GridLayoutManager.LayoutParams layoutParams = (GridLayoutManager.LayoutParams)view.getLayoutParams();
        int spanIndex = layoutParams.getSpanIndex();
        int spanSize = layoutParams.getSpanSize();
        int typeColumn = spanIndex / spanSize;
        int prePosition = position - 1 - typeColumn;
        int allSpanCount = gridLayoutManager.getSpanCount();
        int currentSpanSize = 1;
        int preSpanSize = prePosition >= 0 ? 1 : -1;
        int endSpanSize = -1;
        GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
        if (spanSizeLookup != null) {
            currentSpanSize = spanSizeLookup.getSpanSize(position);
            preSpanSize = prePosition >= 0 ? spanSizeLookup.getSpanSize(prePosition) : -1;
        }
        int currentTypeSpanCount = allSpanCount / currentSpanSize;
        if (spanSizeLookup != null) {
            int remainCalculateColumn = currentTypeSpanCount - typeColumn;
            int adapterItemCount = recyclerAdapter.getItemCount();
            for (int i = 1; i <= remainCalculateColumn; ++i) {
                int endPosition = position + i;
                if (endPosition < adapterItemCount) {
                    endSpanSize = spanSizeLookup.getSpanSize(endPosition);
                    if (currentSpanSize == endSpanSize) continue;
                    break;
                }
                endSpanSize = -1;
                break;
            }
        }
        int leftRightSpace = ItemDecorationUtil.sItemDecorationUtil.mLeftRightSpace;
        int horizontalCenterSpace = ItemDecorationUtil.sItemDecorationUtil.mHorizontalCenterSpace;
        int verticalCenterSpace = ItemDecorationUtil.sItemDecorationUtil.mVerticalCenterSpace;
        int allSpace = leftRightSpace * 2 + (currentTypeSpanCount - 1) * horizontalCenterSpace;
        int averageSpace = allSpace / currentTypeSpanCount;
        int endColumnIndex = currentTypeSpanCount - 1;
        if (typeColumn == 0) {
            outRect.left = leftRightSpace;
            outRect.right = averageSpace - outRect.left;
        } else if (typeColumn == endColumnIndex) {
            outRect.right = leftRightSpace;
            outRect.left = averageSpace - outRect.right;
        } else {
            outRect.left = averageSpace / 2;
            outRect.right = averageSpace / 2;
        }
        boolean isFirstRow = currentSpanSize != preSpanSize;
        outRect.top = isFirstRow ? ItemDecorationUtil.sItemDecorationUtil.mTopSpace : verticalCenterSpace;
        boolean bl = isEndRow = currentSpanSize != endSpanSize;
        if (isEndRow) {
            outRect.bottom = ItemDecorationUtil.sItemDecorationUtil.mBottomSpace;
        }
        return sItemDecorationUtil;
    }
}

