/*
 * Decompiled with CFR 0.152.
 */
package top.ftas.util;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import top.ftas.util.MainThreadUtil;

public class ToastUtil {
    private static Context sApplicationContext = null;

    public static void setApplicationContext(Context applicationContext) {
        sApplicationContext = applicationContext instanceof Activity ? applicationContext.getApplicationContext() : applicationContext;
    }

    public static void toast(int ... args) {
        String msg;
        if (sApplicationContext == null || args == null || args.length == 0) {
            return;
        }
        if (args.length == 1) {
            msg = sApplicationContext.getString(args[0]);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int arg : args) {
                stringBuilder.append(sApplicationContext.getString(arg));
            }
            msg = stringBuilder.toString();
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        if (MainThreadUtil.isMainThread()) {
            Toast.makeText((Context)sApplicationContext, (CharSequence)msg, (int)0).show();
        } else {
            final String finalMsg = msg;
            MainThreadUtil.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)sApplicationContext, (CharSequence)finalMsg, (int)0).show();
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void toast(String ... args) {
        String msg;
        if (sApplicationContext == null || args == null || args.length == 0) {
            return;
        }
        if (args.length == 1) {
            if (args[0] == null) return;
            msg = args[0];
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (String arg : args) {
                if (arg == null) continue;
                stringBuilder.append(arg);
            }
            msg = stringBuilder.toString();
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        if (MainThreadUtil.isMainThread()) {
            Toast.makeText((Context)sApplicationContext, (CharSequence)msg, (int)0).show();
            return;
        } else {
            final String finalMsg = msg;
            MainThreadUtil.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)sApplicationContext, (CharSequence)finalMsg, (int)0).show();
                }
            });
        }
    }
}

