/*
 * Decompiled with CFR 0.152.
 */
package de.robv.android.xposed;

import android.util.Log;
import de.robv.android.xposed.XC_MethodHook;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import top.canyie.pine.Pine;
import top.canyie.pine.callback.MethodHook;
import top.canyie.pine.xposed.PineXposed;

public final class XposedBridge {
    private static String[] sSupportedFeatures = new String[0];
    public static final ClassLoader BOOTCLASSLOADER = ClassLoader.getSystemClassLoader();
    public static final String TAG = "PineXposed";
    @Deprecated
    public static int XPOSED_BRIDGE_VERSION = 90;
    private static final Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> sHookedMethodCallbacks = new HashMap<Member, CopyOnWriteSortedSet<XC_MethodHook>>();

    private XposedBridge() {
    }

    public static int getXposedVersion() {
        return XPOSED_BRIDGE_VERSION;
    }

    public static void setXposedVersion(int version) {
        XPOSED_BRIDGE_VERSION = version;
    }

    public static boolean isFeatureSupported(String featureName) {
        for (String f : sSupportedFeatures) {
            if (!f.equalsIgnoreCase(featureName)) continue;
            return true;
        }
        return false;
    }

    public static String[] getSupportedFeatures() {
        return sSupportedFeatures;
    }

    public static void setSupportedFeatures(String[] features) {
        sSupportedFeatures = features;
    }

    public static synchronized void log(String text) {
        Log.i((String)TAG, (String)text);
    }

    public static synchronized void log(Throwable t) {
        Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XC_MethodHook.Unhook hookMethod(Member hookMethod, XC_MethodHook callback) {
        CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        if (!(hookMethod instanceof Method) && !(hookMethod instanceof Constructor)) {
            throw new IllegalArgumentException("Only methods and constructors can be hooked: " + hookMethod.toString());
        }
        if (Modifier.isAbstract(hookMethod.getModifiers())) {
            throw new IllegalArgumentException("Cannot hook abstract methods: " + hookMethod.toString());
        }
        boolean newMethod = false;
        Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> map = sHookedMethodCallbacks;
        synchronized (map) {
            callbacks = sHookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                callbacks = new CopyOnWriteSortedSet();
                sHookedMethodCallbacks.put(hookMethod, callbacks);
                newMethod = true;
            }
        }
        callbacks.add(callback);
        if (newMethod) {
            Handler handler = new Handler(callbacks);
            Pine.hook((Member)hookMethod, (MethodHook)handler);
        }
        XC_MethodHook xC_MethodHook = callback;
        Objects.requireNonNull(xC_MethodHook);
        return xC_MethodHook.new XC_MethodHook.Unhook(hookMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void unhookMethod(Member hookMethod, XC_MethodHook callback) {
        CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> map = sHookedMethodCallbacks;
        synchronized (map) {
            callbacks = sHookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                return;
            }
        }
        callbacks.remove(callback);
    }

    public static Set<XC_MethodHook.Unhook> hookAllMethods(Class<?> hookClass, String methodName, XC_MethodHook callback) {
        HashSet<XC_MethodHook.Unhook> unhooks = new HashSet<XC_MethodHook.Unhook>();
        for (Method method : hookClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            unhooks.add(XposedBridge.hookMethod(method, callback));
        }
        return unhooks;
    }

    public static Set<XC_MethodHook.Unhook> hookAllConstructors(Class<?> hookClass, XC_MethodHook callback) {
        HashSet<XC_MethodHook.Unhook> unhooks = new HashSet<XC_MethodHook.Unhook>();
        for (Constructor<?> constructor : hookClass.getDeclaredConstructors()) {
            unhooks.add(XposedBridge.hookMethod(constructor, callback));
        }
        return unhooks;
    }

    public static Object invokeOriginalMethod(Member method, Object thisObject, Object[] args) throws NullPointerException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return Pine.invokeOriginalMethod((Member)method, (Object)thisObject, (Object[])args);
    }

    public static final class CopyOnWriteSortedSet<E> {
        private volatile transient Object[] elements = Pine.EMPTY_OBJECT_ARRAY;

        public synchronized boolean add(E e) {
            int index = this.indexOf(e);
            if (index >= 0) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            newElements[this.elements.length] = e;
            Arrays.sort(newElements);
            this.elements = newElements;
            return true;
        }

        public synchronized boolean remove(E e) {
            int index = this.indexOf(e);
            if (index == -1) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length - 1];
            System.arraycopy(this.elements, 0, newElements, 0, index);
            System.arraycopy(this.elements, index + 1, newElements, index, this.elements.length - index - 1);
            this.elements = newElements;
            return true;
        }

        private int indexOf(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        public Object[] getSnapshot() {
            return this.elements;
        }
    }

    static final class Handler
    extends MethodHook {
        private final CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        private final ThreadLocal<ExtData> extDataHolder = new ThreadLocal();

        Handler(CopyOnWriteSortedSet<XC_MethodHook> callbacks) {
            this.callbacks = callbacks;
        }

        public void beforeCall(Pine.CallFrame callFrame) {
            if (PineXposed.disableHooks) {
                return;
            }
            Object[] callbacksSnapshot = this.callbacks.getSnapshot();
            int callbacksLength = callbacksSnapshot.length;
            if (callbacksLength == 0) {
                return;
            }
            ExtData extData = this.extDataHolder.get();
            if (extData == null) {
                extData = new ExtData();
                this.extDataHolder.set(extData);
            }
            XC_MethodHook.MethodHookParam param = new XC_MethodHook.MethodHookParam();
            param.method = callFrame.method;
            param.thisObject = callFrame.thisObject;
            param.args = callFrame.args;
            int beforeIdx = 0;
            do {
                try {
                    ((XC_MethodHook)callbacksSnapshot[beforeIdx]).beforeHookedMethod(param);
                }
                catch (Throwable t) {
                    XposedBridge.log(t);
                    param.setResult(null);
                    param.returnEarly = false;
                    continue;
                }
                if (!param.returnEarly) continue;
                ++beforeIdx;
                break;
            } while (++beforeIdx < callbacksLength);
            callFrame.thisObject = param.thisObject;
            callFrame.args = param.args;
            if (param.returnEarly) {
                if (param.hasThrowable()) {
                    callFrame.setThrowable(param.getThrowable());
                } else {
                    callFrame.setResult(param.getResult());
                }
            }
            extData.callbacks = callbacksSnapshot;
            extData.param = param;
            extData.afterIdx = beforeIdx - 1;
        }

        public void afterCall(Pine.CallFrame callFrame) {
            ExtData extData = this.extDataHolder.get();
            if (extData == null) {
                return;
            }
            Object[] callbacksSnapshot = extData.callbacks;
            if (callbacksSnapshot == null) {
                return;
            }
            XC_MethodHook.MethodHookParam param = extData.param;
            int afterIdx = extData.afterIdx;
            param.thisObject = callFrame.thisObject;
            param.args = callFrame.args;
            if (callFrame.hasThrowable()) {
                param.setThrowable(callFrame.getThrowable());
            } else {
                param.setResult(callFrame.getResult());
            }
            do {
                Object lastResult = param.getResult();
                Throwable lastThrowable = param.getThrowable();
                try {
                    ((XC_MethodHook)callbacksSnapshot[afterIdx]).afterHookedMethod(param);
                }
                catch (Throwable t) {
                    XposedBridge.log(t);
                    if (lastThrowable == null) {
                        param.setResult(lastResult);
                        continue;
                    }
                    param.setThrowable(lastThrowable);
                }
            } while (--afterIdx >= 0);
            callFrame.thisObject = param.thisObject;
            callFrame.args = param.args;
            if (param.hasThrowable()) {
                callFrame.setThrowable(param.getThrowable());
            } else {
                callFrame.setResult(param.getResult());
            }
            extData.callbacks = null;
            extData.param = null;
            extData.afterIdx = 0;
        }

        static final class ExtData {
            Object[] callbacks;
            XC_MethodHook.MethodHookParam param;
            int afterIdx;

            ExtData() {
            }
        }
    }
}

