/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.entry;

import top.canyie.pine.Pine;
import top.canyie.pine.utils.ThreeTuple;

public final class Arm64Entry {
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int CR_SIZE = 7;
    private static final int FPR_SIZE = 8;
    private static final long INT_BITS = 0xFFFFFFFFL;
    private static final long SHORT_BITS = 65535L;
    private static final long BYTE_BITS = 255L;

    private Arm64Entry() {
    }

    static void voidBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static int intBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return (Integer)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static long longBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return (Long)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static double doubleBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return (Double)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static float floatBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return ((Float)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7)).floatValue();
    }

    static boolean booleanBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return (Boolean)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static char charBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return ((Character)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7)).charValue();
    }

    static byte byteBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return (Byte)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static short shortBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return (Short)Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    static Object objectBridge(long artMethod, long extras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        return Arm64Entry.handleBridge(artMethod, extras, sp, x4, x5, x6, x7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object handleBridge(long artMethod, long originExtras, long sp, long x4, long x5, long x6, long x7) throws Throwable {
        Object[] args;
        Object receiver;
        long extras = Pine.cloneExtras(originExtras);
        Pine.log("handleBridge: artMethod=%#x originExtras=%#x extras=%#x sp=%#x", artMethod, originExtras, extras, sp);
        Pine.HookRecord hookRecord = Pine.getHookRecord(artMethod);
        ThreeTuple<long[], long[], double[]> threeTuple = Arm64Entry.getArgs(hookRecord, extras, sp, x4, x5, x6, x7);
        long[] coreRegisters = (long[])threeTuple.a;
        long[] stack = (long[])threeTuple.b;
        double[] fpRegisters = (double[])threeTuple.c;
        int crIndex = 0;
        int stackIndex = 0;
        int fprIndex = 0;
        long thread = Pine.currentArtThread0();
        if (hookRecord.isStatic) {
            receiver = null;
        } else {
            receiver = Pine.getObject(thread, coreRegisters[0]);
            crIndex = 1;
            stackIndex = 1;
        }
        if (hookRecord.paramNumber > 0) {
            args = new Object[hookRecord.paramNumber];
            for (int i = 0; i < hookRecord.paramNumber; ++i) {
                long asLong;
                Object value;
                Class<?> paramType = hookRecord.paramTypes[i];
                if (paramType == Double.TYPE) {
                    value = fprIndex < fpRegisters.length ? Double.valueOf(fpRegisters[fprIndex++]) : Double.valueOf(Double.longBitsToDouble(stack[stackIndex]));
                } else if (paramType == Float.TYPE) {
                    asLong = fprIndex < fpRegisters.length ? Double.doubleToLongBits(fpRegisters[fprIndex++]) : stack[stackIndex];
                    value = Float.valueOf(Float.intBitsToFloat((int)(asLong & 0xFFFFFFFFL)));
                } else {
                    asLong = crIndex < coreRegisters.length ? coreRegisters[crIndex++] : stack[stackIndex];
                    if (paramType.isPrimitive()) {
                        if (paramType == Integer.TYPE) {
                            value = (int)(asLong & 0xFFFFFFFFL);
                        } else if (paramType == Long.TYPE) {
                            value = asLong;
                        } else if (paramType == Boolean.TYPE) {
                            value = (asLong & 0xFFFFFFFFL) != 0L;
                        } else if (paramType == Short.TYPE) {
                            value = (short)(asLong & 0xFFFFL);
                        } else if (paramType == Character.TYPE) {
                            value = Character.valueOf((char)(asLong & 0xFFFFL));
                        } else {
                            if (paramType != Byte.TYPE) throw new AssertionError((Object)("Unknown primitive type: " + paramType));
                            value = (byte)(asLong & 0xFFL);
                        }
                    } else {
                        value = Pine.getObject(thread, asLong & 0xFFFFFFFFL);
                    }
                }
                args[i] = value;
                ++stackIndex;
            }
            return Pine.handleCall(hookRecord, receiver, args);
        } else {
            args = Pine.EMPTY_OBJECT_ARRAY;
        }
        return Pine.handleCall(hookRecord, receiver, args);
    }

    private static ThreeTuple<long[], long[], double[]> getArgs(Pine.HookRecord hookRecord, long extras, long sp, long x4, long x5, long x6, long x7) {
        boolean[] typeWides;
        int crLength = 0;
        int stackLength = 0;
        int fprLength = 0;
        if (hookRecord.paramTypesCache == null) {
            int paramTotal = hookRecord.paramNumber;
            if (!hookRecord.isStatic) {
                crLength = 1;
                stackLength = 1;
                ++paramTotal;
            }
            if (paramTotal != 0) {
                typeWides = new boolean[paramTotal];
                if (!hookRecord.isStatic) {
                    typeWides[0] = false;
                }
                for (int i = 0; i < hookRecord.paramNumber; ++i) {
                    boolean wide;
                    boolean fp;
                    Class<?> paramType = hookRecord.paramTypes[i];
                    if (paramType == Double.TYPE) {
                        fp = true;
                        wide = true;
                    } else if (paramType == Float.TYPE) {
                        fp = true;
                        wide = false;
                    } else if (paramType == Long.TYPE) {
                        fp = false;
                        wide = true;
                    } else {
                        fp = false;
                        wide = false;
                    }
                    if (fp) {
                        if (fprLength < 8) {
                            ++fprLength;
                        }
                    } else if (crLength < 7) {
                        ++crLength;
                    }
                    stackLength += wide ? 8 : 4;
                    if (hookRecord.isStatic) {
                        typeWides[i] = wide;
                        continue;
                    }
                    typeWides[i + 1] = wide;
                }
            } else {
                typeWides = EMPTY_BOOLEAN_ARRAY;
            }
            ParamTypesCache cache = new ParamTypesCache();
            cache.crLength = crLength;
            cache.stackLength = stackLength;
            cache.fprLength = fprLength;
            cache.typeWides = (boolean[])typeWides.clone();
            hookRecord.paramTypesCache = cache;
        } else {
            ParamTypesCache cache = (ParamTypesCache)hookRecord.paramTypesCache;
            crLength = cache.crLength;
            stackLength = cache.stackLength;
            fprLength = cache.fprLength;
            typeWides = (boolean[])cache.typeWides.clone();
        }
        if (sp == 0L) {
            stackLength = 0;
        }
        long[] coreRegisters = crLength != 0 ? new long[crLength] : EMPTY_LONG_ARRAY;
        long[] stack = stackLength != 0 ? new long[stackLength] : EMPTY_LONG_ARRAY;
        double[] fpRegisters = fprLength != 0 ? new double[fprLength] : EMPTY_DOUBLE_ARRAY;
        Pine.getArgsArm64(extras, sp, typeWides, coreRegisters, stack, fpRegisters);
        if (crLength >= 4) {
            coreRegisters[3] = x4;
            if (crLength != 4) {
                coreRegisters[4] = x5;
                if (crLength != 5) {
                    coreRegisters[5] = x6;
                    if (crLength != 6) {
                        coreRegisters[6] = x7;
                    }
                }
            }
        }
        return new ThreeTuple<long[], long[], double[]>(coreRegisters, stack, fpRegisters);
    }

    private static class ParamTypesCache {
        int crLength;
        int stackLength;
        int fprLength;
        boolean[] typeWides;

        private ParamTypesCache() {
        }
    }
}

