/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.utils;

import android.annotation.SuppressLint;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import top.canyie.pine.Pine;

@SuppressLint(value={"PrivateApi"})
public final class Primitives {
    private static final String TAG = "Primitives";
    private static Class<?> unsafeClass;
    private static Object unsafe;
    private static Method putObject;
    private static boolean triedGetShadowKlassField;
    private static Field shadowKlassField;
    private static Field superClassField;
    private static Field classAccessFlagsField;

    public static long currentArtThread() {
        Pine.ensureInitialized();
        return Pine.currentArtThread0();
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    public static void setObjectClass(Object target, Class<?> newClass) {
        if (target.getClass() == newClass) {
            return;
        }
        if (!triedGetShadowKlassField) {
            triedGetShadowKlassField = true;
            try {
                shadowKlassField = Object.class.getDeclaredField("shadow$_klass_");
                shadowKlassField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.w((String)TAG, (String)"Object.shadow$_klass_ not found, use Unsafe.", (Throwable)e);
            }
        }
        try {
            if (shadowKlassField != null) {
                shadowKlassField.set(target, newClass);
            } else {
                Primitives.ensureUnsafeReady();
                if (putObject == null) {
                    putObject = unsafeClass.getDeclaredMethod("putObject", Object.class, Long.TYPE, Object.class);
                    putObject.setAccessible(true);
                }
                putObject.invoke(unsafe, target, 0L, newClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setSuperClass(Class<?> target, Class<?> newSuperClass) {
        if (target.getSuperclass() == newSuperClass) {
            return;
        }
        if (superClassField == null) {
            try {
                superClassField = Class.class.getDeclaredField("superClass");
                superClassField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Class.superClass not found", e);
            }
        }
        try {
            superClassField.set(target, newSuperClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getFieldOffset(Field field) throws Exception {
        try {
            Field offset = Field.class.getDeclaredField("offset");
            offset.setAccessible(true);
            return offset.getInt(field);
        }
        catch (Exception offset) {
            try {
                Method getOffset = Field.class.getDeclaredMethod("getOffset", new Class[0]);
                getOffset.setAccessible(true);
                return (Integer)getOffset.invoke((Object)field, new Object[0]);
            }
            catch (Exception getOffset) {
                Primitives.ensureUnsafeReady();
                Method objectFieldOffset = unsafeClass.getDeclaredMethod("objectFieldOffset", Field.class);
                objectFieldOffset.setAccessible(true);
                return (Integer)objectFieldOffset.invoke(unsafe, field);
            }
        }
    }

    public static void removeClassFinalFlag(Class<?> target) {
        if (!Modifier.isFinal(target.getModifiers())) {
            return;
        }
        if (classAccessFlagsField == null) {
            try {
                classAccessFlagsField = Class.class.getDeclaredField("accessFlags");
                classAccessFlagsField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Class.accessFlags not found", e);
            }
        }
        try {
            classAccessFlagsField.setInt(target, classAccessFlagsField.getInt(target) & 0xFFFFFFEF);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] int2Bytes(int value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
    }

    public static int bytes2Int(byte[] src) {
        return src[0] & 0xFF | (src[1] & 0xFF) << 8 | (src[2] & 0xFF) << 16 | (src[3] & 0xFF) << 24;
    }

    public static long ints2Long(int l, int h) {
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static double ints2Double(int a, int b) {
        return Double.longBitsToDouble(Primitives.ints2Long(a, b));
    }

    public static double floats2Double(float l, float h) {
        return Double.longBitsToDouble(Primitives.ints2Long(Float.floatToIntBits(l), Float.floatToIntBits(h)));
    }

    public static int evenUp(int n) {
        if ((n & 1) == 1) {
            ++n;
        }
        return n;
    }

    private static Object getUnsafe() throws Exception {
        try {
            Method getUnsafe = unsafeClass.getDeclaredMethod("getUnsafe", new Class[0]);
            getUnsafe.setAccessible(true);
            return getUnsafe.invoke(null, new Object[0]);
        }
        catch (Exception getUnsafe) {
            Field theUnsafe;
            try {
                theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            }
            catch (NoSuchFieldException ignored) {
                theUnsafe = unsafeClass.getDeclaredField("THE_ONE");
            }
            theUnsafe.setAccessible(true);
            return theUnsafe.get(null);
        }
    }

    private static void ensureUnsafeReady() {
        if (unsafe != null) {
            return;
        }
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
            unsafe = Primitives.getUnsafe();
        }
        catch (Exception e) {
            throw new RuntimeException("Unsafe API is unavailable", e);
        }
    }
}

