/*
 * Decompiled with CFR 0.152.
 */
package top.aexp.swaggershowdoc.server.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import top.aexp.swaggershowdoc.Swagger2ShowDocBuilder;
import top.aexp.swaggershowdoc.config.Config;
import top.aexp.swaggershowdoc.server.models.BaseResponse;
import top.aexp.swaggershowdoc.server.models.ConfigInfo;
import top.aexp.swaggershowdoc.server.models.ShowDocBuildConfig;
import top.aexp.swaggershowdoc.server.models.SwaggerBuildConfig;

@Controller
public class ApiDocController {
    private static final Logger log = LoggerFactory.getLogger(ApiDocController.class);
    private RestTemplate restTemplate = new RestTemplate();

    @RequestMapping(value={"/"})
    public String index() {
        return "index.html";
    }

    @ResponseBody
    @PostMapping(value={"/updateShowDoc"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    public BaseResponse updateShowDoc(@RequestBody @Validated ConfigInfo configInfo) throws MalformedURLException {
        ShowDocBuildConfig sdConfig = configInfo.getShowDocConfig();
        List swaggerConfigList = configInfo.getSwaggerConfigList();
        Config config = new Config(sdConfig.getUrl(), sdConfig.getApiKey(), sdConfig.getApiToken());
        this.addModule(swaggerConfigList, config);
        try {
            Swagger2ShowDocBuilder.start((Config)config);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.ok();
    }

    private void addModule(List<SwaggerBuildConfig> swaggerConfigList, Config config) throws MalformedURLException {
        for (SwaggerBuildConfig swaggerBuildConfig : swaggerConfigList) {
            String path;
            Integer port = swaggerBuildConfig.getPort();
            if (port == null) {
                port = 80;
            }
            path = StringUtils.isEmpty((Object)(path = swaggerBuildConfig.getPath())) ? "" : "/" + path;
            path = path + "/v2/api-docs";
            if (!CollectionUtils.isEmpty((Collection)swaggerBuildConfig.getParams())) {
                String params = "";
                for (String param : swaggerBuildConfig.getParams()) {
                    if (StringUtils.isEmpty((Object)param)) continue;
                    if (StringUtils.isEmpty((Object)params)) {
                        params = param;
                        continue;
                    }
                    params = params + "&" + param;
                }
                if (!StringUtils.isEmpty((Object)params)) {
                    path = path + "?" + params;
                }
            }
            URL url = new URL("http", swaggerBuildConfig.getIp(), port, path);
            this.restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            Callable<String> callable = () -> (String)this.restTemplate.getForObject(url.toString(), String.class, new Object[0]);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<String> submit = executor.submit(callable);
            String swaggerStr = null;
            try {
                swaggerStr = submit.get(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8fde\u63a5\u8d85\u65f6");
            }
            assert (swaggerStr != null);
            config.addModule(swaggerBuildConfig.getModule(), swaggerStr);
        }
    }
}

