/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KCallables;
import org.jetbrains.annotations.NotNull;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.MapperFeature;
import tools.jackson.module.kotlin.ArgumentBucket;
import tools.jackson.module.kotlin.BucketGenerator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001eR\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Ltools/jackson/module/kotlin/ValueCreator;", "T", "", "<init>", "()V", "callable", "Lkotlin/reflect/KFunction;", "getCallable", "()Lkotlin/reflect/KFunction;", "accessible", "", "getAccessible", "()Z", "bucketGenerator", "Ltools/jackson/module/kotlin/BucketGenerator;", "getBucketGenerator", "()Ltools/jackson/module/kotlin/BucketGenerator;", "generateBucket", "Ltools/jackson/module/kotlin/ArgumentBucket;", "valueParameters", "", "Lkotlin/reflect/KParameter;", "getValueParameters", "()Ljava/util/List;", "checkAccessibility", "", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "callBy", "args", "(Ltools/jackson/module/kotlin/ArgumentBucket;)Ljava/lang/Object;", "Ltools/jackson/module/kotlin/ConstructorValueCreator;", "Ltools/jackson/module/kotlin/MethodValueCreator;", "jackson-module-kotlin"})
public abstract class ValueCreator<T> {
    private ValueCreator() {
    }

    @NotNull
    protected abstract KFunction<T> getCallable();

    protected abstract boolean getAccessible();

    @NotNull
    protected abstract BucketGenerator getBucketGenerator();

    @NotNull
    public final ArgumentBucket generateBucket() {
        return this.getBucketGenerator().generate();
    }

    @NotNull
    public final List<KParameter> getValueParameters() {
        return KCallables.getValueParameters((KCallable)((KCallable)this.getCallable()));
    }

    public final void checkAccessibility(@NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        if (!this.getAccessible() && ctxt.getConfig().isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS) || this.getAccessible() && ctxt.getConfig().isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS)) {
            return;
        }
        throw new IllegalAccessException("Cannot access to function or companion object instance, target: " + this.getCallable());
    }

    public final T callBy(@NotNull ArgumentBucket args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.isFullInitialized()) {
            Object[] objectArray = args.getArguments();
            object = this.getCallable().call(Arrays.copyOf(objectArray, objectArray.length));
        } else {
            object = this.getCallable().callBy((Map)args);
        }
        return (T)object;
    }

    public /* synthetic */ ValueCreator(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

