/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.module.kotlin.GenericValueClassBoxConverter;
import tools.jackson.module.kotlin.IntValueClassBoxConverter;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.JavaUuidValueClassBoxConverter;
import tools.jackson.module.kotlin.LongValueClassBoxConverter;
import tools.jackson.module.kotlin.ReflectionCache;
import tools.jackson.module.kotlin.StringValueClassBoxConverter;
import tools.jackson.module.kotlin.ValueClassBoxConverter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 $*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u0007\u001e\u001f !\"#$B%\b\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0015\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0002%&\u00a8\u0006'"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer;", "S", "D", "", "Ltools/jackson/databind/KeyDeserializer;", "converter", "Ltools/jackson/module/kotlin/ValueClassBoxConverter;", "creatorHandle", "Ljava/lang/invoke/MethodHandle;", "<init>", "(Ltools/jackson/module/kotlin/ValueClassBoxConverter;Ljava/lang/invoke/MethodHandle;)V", "boxedClass", "Ljava/lang/Class;", "unboxedClass", "getUnboxedClass", "()Ljava/lang/Class;", "handle", "getHandle", "()Ljava/lang/invoke/MethodHandle;", "errorMessage", "", "boxedType", "Ltools/jackson/databind/JavaType;", "invokeExact", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "deserializeKey", "key", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "WrapsSpecified", "WrapsInt", "WrapsLong", "WrapsString", "WrapsJavaUuid", "WrapsAny", "Companion", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsAny;", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsSpecified;", "jackson-module-kotlin"})
public abstract class ValueClassKeyDeserializer<S, D>
extends KeyDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<D> boxedClass;
    @NotNull
    private final MethodHandle handle;

    private ValueClassKeyDeserializer(ValueClassBoxConverter<S, D> converter, MethodHandle creatorHandle) {
        this.boxedClass = converter.getBoxedClass();
        MethodHandle methodHandle = MethodHandles.filterReturnValue(creatorHandle, converter.getBoxHandle());
        Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"filterReturnValue(...)");
        this.handle = methodHandle;
    }

    @NotNull
    protected abstract Class<?> getUnboxedClass();

    @NotNull
    protected final MethodHandle getHandle() {
        return this.handle;
    }

    private final String errorMessage(JavaType boxedType) {
        return "Could not find (Map) Key deserializer for types wrapped in " + boxedType;
    }

    @NotNull
    protected abstract D invokeExact(S var1);

    @NotNull
    public final Object deserializeKey(@Nullable String key, @NotNull DeserializationContext ctxt) {
        D d;
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JavaType unboxedJavaType = ctxt.constructType(this.getUnboxedClass());
        try {
            Object value = ctxt.findKeyDeserializer(unboxedJavaType, null).deserializeKey(key, ctxt);
            d = this.invokeExact(value);
        }
        catch (InvalidDefinitionException e) {
            JsonParser jsonParser = ctxt.getParser();
            JavaType javaType = ctxt.constructType(this.boxedClass);
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructType(...)");
            throw DatabindException.from((JsonParser)jsonParser, (String)this.errorMessage(javaType), (Throwable)e);
        }
        return d;
    }

    public /* synthetic */ ValueClassKeyDeserializer(ValueClassBoxConverter converter, MethodHandle creatorHandle, DefaultConstructorMarker $constructor_marker) {
        this(converter, creatorHandle);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$Companion;", "", "<init>", "()V", "createOrNull", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer;", "boxedClass", "Lkotlin/reflect/KClass;", "cache", "Ltools/jackson/module/kotlin/ReflectionCache;", "jackson-module-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ValueClassKeyDeserializer<?, ?> createOrNull(@NotNull KClass<?> boxedClass, @NotNull ReflectionCache cache) {
            ValueClassKeyDeserializer valueClassKeyDeserializer;
            ValueClassBoxConverter<?, ?> converter;
            Intrinsics.checkNotNullParameter(boxedClass, (String)"boxedClass");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            Object object = KClasses.getPrimaryConstructor(boxedClass);
            if (object == null || (object = ReflectJvmMapping.getJavaMethod((KFunction)object)) == null) {
                return null;
            }
            Object creator = object;
            Class<?> clazz = ((Method)creator).getReturnType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
            ValueClassBoxConverter<?, ?> valueClassBoxConverter = converter = cache.getValueClassBoxConverter(clazz, boxedClass);
            if (valueClassBoxConverter instanceof IntValueClassBoxConverter) {
                valueClassKeyDeserializer = new WrapsInt((IntValueClassBoxConverter)converter, (Method)creator);
            } else if (valueClassBoxConverter instanceof LongValueClassBoxConverter) {
                valueClassKeyDeserializer = new WrapsLong((LongValueClassBoxConverter)converter, (Method)creator);
            } else if (valueClassBoxConverter instanceof StringValueClassBoxConverter) {
                valueClassKeyDeserializer = new WrapsString((StringValueClassBoxConverter)converter, (Method)creator);
            } else if (valueClassBoxConverter instanceof JavaUuidValueClassBoxConverter) {
                valueClassKeyDeserializer = new WrapsJavaUuid((JavaUuidValueClassBoxConverter)converter, (Method)creator);
            } else if (valueClassBoxConverter instanceof GenericValueClassBoxConverter) {
                valueClassKeyDeserializer = new WrapsAny((GenericValueClassBoxConverter)converter, (Method)creator);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return valueClassKeyDeserializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\b\b\u0003\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00028\u00032\u0006\u0010\u0010\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsAny;", "S", "D", "", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer;", "converter", "Ltools/jackson/module/kotlin/GenericValueClassBoxConverter;", "creator", "Ljava/lang/reflect/Method;", "<init>", "(Ltools/jackson/module/kotlin/GenericValueClassBoxConverter;Ljava/lang/reflect/Method;)V", "unboxedClass", "Ljava/lang/Class;", "getUnboxedClass", "()Ljava/lang/Class;", "invokeExact", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "jackson-module-kotlin"})
    public static final class WrapsAny<S, D>
    extends ValueClassKeyDeserializer<S, D> {
        @NotNull
        private final Class<?> unboxedClass;

        public WrapsAny(@NotNull GenericValueClassBoxConverter<S, D> converter, @NotNull Method creator) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            ValueClassBoxConverter valueClassBoxConverter = converter;
            MethodType methodType = InternalCommonsKt.getANY_TO_ANY_METHOD_TYPE();
            Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"<get-ANY_TO_ANY_METHOD_TYPE>(...)");
            super(valueClassBoxConverter, InternalCommonsKt.unreflectAsType(creator, methodType), null);
            Class<?> clazz = creator.getReturnType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
            this.unboxedClass = clazz;
        }

        @Override
        @NotNull
        protected Class<?> getUnboxedClass() {
            return this.unboxedClass;
        }

        @Override
        @NotNull
        protected D invokeExact(S value) {
            return (D)this.getHandle().invokeExact(value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u0010\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsInt;", "D", "", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsSpecified;", "", "converter", "Ltools/jackson/module/kotlin/IntValueClassBoxConverter;", "creator", "Ljava/lang/reflect/Method;", "<init>", "(Ltools/jackson/module/kotlin/IntValueClassBoxConverter;Ljava/lang/reflect/Method;)V", "unboxedClass", "Ljava/lang/Class;", "getUnboxedClass", "()Ljava/lang/Class;", "invokeExact", "value", "(I)Ljava/lang/Object;", "jackson-module-kotlin"})
    public static final class WrapsInt<D>
    extends WrapsSpecified<Integer, D> {
        public WrapsInt(@NotNull IntValueClassBoxConverter<D> converter, @NotNull Method creator) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            super((ValueClassBoxConverter)converter, creator, null);
        }

        @Override
        @NotNull
        protected Class<?> getUnboxedClass() {
            return Integer.TYPE;
        }

        @Override
        @NotNull
        protected D invokeExact(int value) {
            return (D)this.getHandle().invokeExact(value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000f\u001a\u00028\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0014\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsJavaUuid;", "D", "", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsSpecified;", "Ljava/util/UUID;", "converter", "Ltools/jackson/module/kotlin/JavaUuidValueClassBoxConverter;", "creator", "Ljava/lang/reflect/Method;", "<init>", "(Ltools/jackson/module/kotlin/JavaUuidValueClassBoxConverter;Ljava/lang/reflect/Method;)V", "unboxedClass", "Ljava/lang/Class;", "getUnboxedClass", "()Ljava/lang/Class;", "invokeExact", "value", "(Ljava/util/UUID;)Ljava/lang/Object;", "jackson-module-kotlin"})
    public static final class WrapsJavaUuid<D>
    extends WrapsSpecified<UUID, D> {
        public WrapsJavaUuid(@NotNull JavaUuidValueClassBoxConverter<D> converter, @NotNull Method creator) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            super((ValueClassBoxConverter)converter, creator, null);
        }

        @Override
        @NotNull
        protected Class<?> getUnboxedClass() {
            return UUID.class;
        }

        @Override
        @NotNull
        protected D invokeExact(@Nullable UUID value) {
            return (D)this.getHandle().invokeExact(value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u0010\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsLong;", "D", "", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsSpecified;", "", "converter", "Ltools/jackson/module/kotlin/LongValueClassBoxConverter;", "creator", "Ljava/lang/reflect/Method;", "<init>", "(Ltools/jackson/module/kotlin/LongValueClassBoxConverter;Ljava/lang/reflect/Method;)V", "unboxedClass", "Ljava/lang/Class;", "getUnboxedClass", "()Ljava/lang/Class;", "invokeExact", "value", "(J)Ljava/lang/Object;", "jackson-module-kotlin"})
    public static final class WrapsLong<D>
    extends WrapsSpecified<Long, D> {
        public WrapsLong(@NotNull LongValueClassBoxConverter<D> converter, @NotNull Method creator) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            super((ValueClassBoxConverter)converter, creator, null);
        }

        @Override
        @NotNull
        protected Class<?> getUnboxedClass() {
            return Long.TYPE;
        }

        @Override
        @NotNull
        protected D invokeExact(long value) {
            return (D)this.getHandle().invokeExact(value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\u0004\b\u0002\u0010\u0001*\b\b\u0003\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B%\b\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\n\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsSpecified;", "S", "D", "", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer;", "converter", "Ltools/jackson/module/kotlin/ValueClassBoxConverter;", "creator", "Ljava/lang/reflect/Method;", "<init>", "(Ltools/jackson/module/kotlin/ValueClassBoxConverter;Ljava/lang/reflect/Method;)V", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsInt;", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsJavaUuid;", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsLong;", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsString;", "jackson-module-kotlin"})
    public static abstract class WrapsSpecified<S, D>
    extends ValueClassKeyDeserializer<S, D> {
        private WrapsSpecified(ValueClassBoxConverter<S, D> converter, Method creator) {
            super(converter, InternalCommonsKt.unreflect(creator), null);
        }

        public /* synthetic */ WrapsSpecified(ValueClassBoxConverter converter, Method creator, DefaultConstructorMarker $constructor_marker) {
            this(converter, creator);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000f\u001a\u00028\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0014\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsString;", "D", "", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$WrapsSpecified;", "", "converter", "Ltools/jackson/module/kotlin/StringValueClassBoxConverter;", "creator", "Ljava/lang/reflect/Method;", "<init>", "(Ltools/jackson/module/kotlin/StringValueClassBoxConverter;Ljava/lang/reflect/Method;)V", "unboxedClass", "Ljava/lang/Class;", "getUnboxedClass", "()Ljava/lang/Class;", "invokeExact", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "jackson-module-kotlin"})
    public static final class WrapsString<D>
    extends WrapsSpecified<String, D> {
        public WrapsString(@NotNull StringValueClassBoxConverter<D> converter, @NotNull Method creator) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            super((ValueClassBoxConverter)converter, creator, null);
        }

        @Override
        @NotNull
        protected Class<?> getUnboxedClass() {
            return String.class;
        }

        @Override
        @NotNull
        protected D invokeExact(@Nullable String value) {
            return (D)this.getHandle().invokeExact(value);
        }
    }
}

