/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.ValueClassUnboxConverter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Ltools/jackson/module/kotlin/GenericValueClassUnboxConverter;", "T", "", "Ltools/jackson/module/kotlin/ValueClassUnboxConverter;", "valueClass", "Ljava/lang/Class;", "unboxedType", "Ljava/lang/reflect/Type;", "unboxMethod", "Ljava/lang/reflect/Method;", "<init>", "(Ljava/lang/Class;Ljava/lang/reflect/Type;Ljava/lang/reflect/Method;)V", "getValueClass", "()Ljava/lang/Class;", "getUnboxedType", "()Ljava/lang/reflect/Type;", "unboxHandle", "Ljava/lang/invoke/MethodHandle;", "getUnboxHandle", "()Ljava/lang/invoke/MethodHandle;", "convert", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "jackson-module-kotlin"})
public final class GenericValueClassUnboxConverter<T>
extends ValueClassUnboxConverter<T, Object> {
    @NotNull
    private final Class<T> valueClass;
    @NotNull
    private final Type unboxedType;
    @NotNull
    private final MethodHandle unboxHandle;

    public GenericValueClassUnboxConverter(@NotNull Class<T> valueClass, @NotNull Type unboxedType, @NotNull Method unboxMethod) {
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        Intrinsics.checkNotNullParameter((Object)unboxedType, (String)"unboxedType");
        Intrinsics.checkNotNullParameter((Object)unboxMethod, (String)"unboxMethod");
        super(null);
        this.valueClass = valueClass;
        this.unboxedType = unboxedType;
        MethodType methodType = InternalCommonsKt.getANY_TO_ANY_METHOD_TYPE();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"<get-ANY_TO_ANY_METHOD_TYPE>(...)");
        this.unboxHandle = InternalCommonsKt.unreflectAsType(unboxMethod, methodType);
    }

    @Override
    @NotNull
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    @NotNull
    public Type getUnboxedType() {
        return this.unboxedType;
    }

    @Override
    @NotNull
    public MethodHandle getUnboxHandle() {
        return this.unboxHandle;
    }

    @Nullable
    public Object convert(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getUnboxHandle().invokeExact(value);
    }
}

