/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import com.fasterxml.jackson.annotation.JsonFormat;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.UByteSerializer;
import tools.jackson.module.kotlin.UIntSerializer;
import tools.jackson.module.kotlin.ULongSerializer;
import tools.jackson.module.kotlin.UShortSerializer;
import tools.jackson.module.kotlin.ValueClassSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Ltools/jackson/module/kotlin/KotlinSerializers;", "Ltools/jackson/databind/ser/Serializers$Base;", "()V", "findSerializer", "Ltools/jackson/databind/ValueSerializer;", "config", "Ltools/jackson/databind/SerializationConfig;", "type", "Ltools/jackson/databind/JavaType;", "beanDesc", "Ltools/jackson/databind/BeanDescription;", "formatOverrides", "Lcom/fasterxml/jackson/annotation/JsonFormat$Value;", "jackson-module-kotlin"})
public final class KotlinSerializers
extends Serializers.Base {
    @Nullable
    public ValueSerializer<?> findSerializer(@Nullable SerializationConfig config, @NotNull JavaType type, @Nullable BeanDescription beanDesc, @Nullable JsonFormat.Value formatOverrides) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class rawClass = type.getRawClass();
        if (Intrinsics.areEqual(UByte.class, (Object)rawClass)) {
            object = (ValueSerializer)UByteSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(UShort.class, (Object)rawClass)) {
            object = (ValueSerializer)UShortSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(UInt.class, (Object)rawClass)) {
            object = (ValueSerializer)UIntSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(ULong.class, (Object)rawClass)) {
            object = (ValueSerializer)ULongSerializer.INSTANCE;
        } else {
            Intrinsics.checkNotNull((Object)rawClass);
            object = InternalCommonsKt.isUnboxableValueClass(rawClass) ? (ValueSerializer)ValueClassSerializer.Companion.from(rawClass) : null;
        }
        return object;
    }
}

