/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.Deserializers;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.JavaToKotlinDurationConverter;
import tools.jackson.module.kotlin.KotlinDeserializersKt;
import tools.jackson.module.kotlin.ReflectionCache;
import tools.jackson.module.kotlin.RegexDeserializer;
import tools.jackson.module.kotlin.SequenceDeserializer;
import tools.jackson.module.kotlin.UByteDeserializer;
import tools.jackson.module.kotlin.UIntDeserializer;
import tools.jackson.module.kotlin.ULongDeserializer;
import tools.jackson.module.kotlin.UShortDeserializer;
import tools.jackson.module.kotlin.ValueClassBoxConverter;
import tools.jackson.module.kotlin.WrapsNullableValueClassBoxDeserializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltools/jackson/module/kotlin/KotlinDeserializers;", "Ltools/jackson/databind/deser/Deserializers$Base;", "cache", "Ltools/jackson/module/kotlin/ReflectionCache;", "useJavaDurationConversion", "", "(Ltools/jackson/module/kotlin/ReflectionCache;Z)V", "findBeanDeserializer", "Ltools/jackson/databind/ValueDeserializer;", "type", "Ltools/jackson/databind/JavaType;", "config", "Ltools/jackson/databind/DeserializationConfig;", "beanDesc", "Ltools/jackson/databind/BeanDescription;", "hasDeserializerFor", "valueType", "Ljava/lang/Class;", "jackson-module-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinDeserializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDeserializers.kt\ntools/jackson/module/kotlin/KotlinDeserializers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class KotlinDeserializers
extends Deserializers.Base {
    @NotNull
    private final ReflectionCache cache;
    private final boolean useJavaDurationConversion;

    public KotlinDeserializers(@NotNull ReflectionCache cache, boolean useJavaDurationConversion) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
        this.useJavaDurationConversion = useJavaDurationConversion;
    }

    @Nullable
    public ValueDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @Nullable DeserializationConfig config, @Nullable BeanDescription beanDesc) {
        ValueDeserializer valueDeserializer2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class rawClass = type.getRawClass();
        if (type.isInterface() && Intrinsics.areEqual((Object)rawClass, Sequence.class)) {
            valueDeserializer2 = (ValueDeserializer)SequenceDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, Regex.class)) {
            valueDeserializer2 = (ValueDeserializer)RegexDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UByte.class)) {
            valueDeserializer2 = (ValueDeserializer)UByteDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UShort.class)) {
            valueDeserializer2 = (ValueDeserializer)UShortDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UInt.class)) {
            valueDeserializer2 = (ValueDeserializer)UIntDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, ULong.class)) {
            valueDeserializer2 = (ValueDeserializer)ULongDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, Duration.class)) {
            JavaToKotlinDurationConverter javaToKotlinDurationConverter;
            JavaToKotlinDurationConverter it = javaToKotlinDurationConverter = JavaToKotlinDurationConverter.INSTANCE;
            boolean bl = false;
            JavaToKotlinDurationConverter javaToKotlinDurationConverter2 = this.useJavaDurationConversion ? javaToKotlinDurationConverter : null;
            valueDeserializer2 = (ValueDeserializer)(javaToKotlinDurationConverter2 != null ? javaToKotlinDurationConverter2.getDelegatingDeserializer() : null);
        } else {
            Intrinsics.checkNotNull((Object)rawClass);
            if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
                WrapsNullableValueClassBoxDeserializer wrapsNullableValueClassBoxDeserializer;
                Method method = KotlinDeserializersKt.access$findValueCreator(type, rawClass);
                if (method != null) {
                    Method it = method;
                    boolean bl = false;
                    Class<?> unboxedClass = it.getReturnType();
                    Intrinsics.checkNotNull(unboxedClass);
                    ValueClassBoxConverter<?, ?> converter = this.cache.getValueClassBoxConverter(unboxedClass, JvmClassMappingKt.getKotlinClass((Class)rawClass));
                    wrapsNullableValueClassBoxDeserializer = new WrapsNullableValueClassBoxDeserializer(it, converter);
                } else {
                    wrapsNullableValueClassBoxDeserializer = null;
                }
                valueDeserializer2 = (ValueDeserializer)wrapsNullableValueClassBoxDeserializer;
            } else {
                valueDeserializer2 = null;
            }
        }
        return valueDeserializer2;
    }

    public boolean hasDeserializerFor(@NotNull DeserializationConfig config, @NotNull Class<?> valueType) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        return Intrinsics.areEqual(valueType, Sequence.class) || Intrinsics.areEqual(valueType, Regex.class) || Intrinsics.areEqual(valueType, UByte.class) || Intrinsics.areEqual(valueType, UShort.class) || Intrinsics.areEqual(valueType, UInt.class) || Intrinsics.areEqual(valueType, ULong.class) || Intrinsics.areEqual(valueType, Duration.class);
    }
}

