/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.jaxb.ser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.ser.std.StdSerializer;

public class DataHandlerSerializer
extends StdSerializer<DataHandler> {
    public DataHandlerSerializer() {
        super(DataHandler.class);
    }

    public void serialize(DataHandler value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try (InputStream in = value.getInputStream();){
            int len = in.read(buffer);
            while (len > 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
        g.writeBinary(out.toByteArray());
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.STRING);
        }
    }
}

