/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.guice7;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.AnnotationMap;
import tools.jackson.databind.introspect.NopAnnotationIntrospector;

public class GuiceAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public JacksonInject.Value findInjectableValue(MapperConfig<?> config, AnnotatedMember m) {
        Object id = this._findGuiceInjectId(m);
        if (id == null) {
            return null;
        }
        return JacksonInject.Value.forId((Object)id);
    }

    private Object _findGuiceInjectId(AnnotatedMember m) {
        Annotation guiceAnnotation;
        AnnotatedMember guiceMember;
        if (m.getAnnotation(JacksonInject.class) == null && m.getAnnotation(jakarta.inject.Inject.class) == null && m.getAnnotation(Inject.class) == null) {
            return null;
        }
        if (m instanceof AnnotatedField || m instanceof AnnotatedParameter) {
            guiceMember = m;
            AnnotationMap anns = m.getAllAnnotations();
            guiceAnnotation = this.findBindingAnnotation(anns.annotations());
        } else if (m instanceof AnnotatedMethod) {
            AnnotatedMethod a = (AnnotatedMethod)m;
            if (a.getParameterCount() != 1) {
                return null;
            }
            guiceMember = a.getParameter(0);
            Annotation[] annotations = a.getMember().getParameterAnnotations()[0];
            guiceAnnotation = this.findBindingAnnotation(Arrays.asList(annotations));
        } else {
            return null;
        }
        if (guiceAnnotation == null) {
            return Key.get((Type)guiceMember.getRawType());
        }
        return Key.get((Type)guiceMember.getRawType(), (Annotation)guiceAnnotation);
    }

    private Annotation findBindingAnnotation(Iterable<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(BindingAnnotation.class) && !annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            return annotation;
        }
        return null;
    }
}

