/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import java.util.function.BiConsumer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;

final class SettableStringProperty
extends OptimizedSettableBeanProperty<SettableStringProperty> {
    private static final long serialVersionUID = 1L;
    private final BiConsumer<Object, String> _optimizedSetter;

    public SettableStringProperty(SettableBeanProperty src, BiConsumer<Object, String> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        this.set(ctxt, bean, p.getString());
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this.setAndReturn(ctxt, instance, p.getString());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        try {
            this._optimizedSetter.accept(bean, (String)value);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, value, e);
        }
    }
}

