/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.androidrecord;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AccessorNamingStrategy;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.BasicClassIntrospector;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import tools.jackson.databind.introspect.POJOPropertiesCollector;
import tools.jackson.databind.introspect.PotentialCreator;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.module.androidrecord.PackageVersion;

public class AndroidRecordModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public void setupModule(JacksonModule.SetupContext context) {
        super.setupModule(context);
        MapperBuilder builder = (MapperBuilder)context.getOwner();
        builder.classIntrospector((ClassIntrospector)new AndroidRecordClassIntrospector());
        context.insertAnnotationIntrospector((AnnotationIntrospector)new AndroidRecordAnnotationIntrospector());
    }

    static boolean isDesugaredRecordClass(Class<?> raw) {
        Class<?> sup = raw.getSuperclass();
        return sup != null && sup.getName().equals("com.android.tools.r8.RecordTag");
    }

    static Stream<Field> getDesugaredRecordComponents(Class<?> raw) {
        return Arrays.stream(raw.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers()));
    }

    static Class<?> arrayTypeCompat(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    static Type fixAndroidGenericType(Type type) {
        Class rawComponentClass;
        Type rawType;
        ParameterizedType parameterizedType;
        if (type instanceof GenericArrayType) {
            Type componentType = AndroidRecordModule.fixAndroidGenericType(((GenericArrayType)type).getGenericComponentType());
            if (componentType instanceof Class) {
                return AndroidRecordModule.arrayTypeCompat((Class)componentType);
            }
        } else if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getOwnerType() == null && (rawType = parameterizedType.getRawType()) instanceof Class && (rawComponentClass = (Class)rawType).getTypeParameters().length == 0) {
            return rawComponentClass;
        }
        return type;
    }

    static class AndroidRecordClassIntrospector
    extends BasicClassIntrospector {
        private static final long serialVersionUID = 1L;

        public AndroidRecordClassIntrospector() {
        }

        AndroidRecordClassIntrospector(MapperConfig<?> config) {
            super(config);
        }

        protected POJOPropertiesCollector collectProperties(JavaType type, AnnotatedClass classDef, boolean forSerialization, String mutatorPrefix) {
            if (AndroidRecordModule.isDesugaredRecordClass(type.getRawClass())) {
                AndroidRecordNaming accNaming = new AndroidRecordNaming(this._config, classDef);
                return this.constructPropertyCollector(type, classDef, forSerialization, (AccessorNamingStrategy)accNaming);
            }
            return super.collectProperties(type, classDef, forSerialization, mutatorPrefix);
        }

        public BasicClassIntrospector forMapper() {
            return this;
        }

        public BasicClassIntrospector forOperation(MapperConfig<?> config) {
            return new AndroidRecordClassIntrospector(config);
        }
    }

    static class AndroidRecordAnnotationIntrospector
    extends AnnotationIntrospector {
        private static final long serialVersionUID = 1L;

        AndroidRecordAnnotationIntrospector() {
        }

        public Version version() {
            return PackageVersion.VERSION;
        }

        public PotentialCreator findPreferredCreator(MapperConfig<?> config, AnnotatedClass valueClass, List<PotentialCreator> declaredConstructors, List<PotentialCreator> declaredFactories) {
            PotentialCreator foundCreator = null;
            if (AndroidRecordModule.isDesugaredRecordClass(valueClass.getRawType())) {
                Map<String, Type> components = AndroidRecordModule.getDesugaredRecordComponents(valueClass.getRawType()).collect(Collectors.toMap(Field::getName, Field::getGenericType));
                for (PotentialCreator creator : declaredConstructors) {
                    AnnotatedConstructor constructor;
                    Parameter[] parameters;
                    Map<String, Type> parameterTypes;
                    if (!(creator.creator() instanceof AnnotatedConstructor) || !(parameterTypes = Arrays.stream(parameters = (constructor = (AnnotatedConstructor)creator.creator()).getAnnotated().getParameters()).collect(Collectors.toMap(Parameter::getName, parameter -> AndroidRecordModule.fixAndroidGenericType(parameter.getParameterizedType())))).equals(components)) continue;
                    if (foundCreator != null) {
                        throw new IllegalArgumentException(String.format("Multiple constructors match set of components for record %s", valueClass.getRawType().getName()));
                    }
                    foundCreator = creator.introspectParamNames(config, (PropertyName[])Arrays.stream(parameters).map(Parameter::getName).map(PropertyName::new).toArray(PropertyName[]::new));
                }
            }
            return foundCreator;
        }
    }

    static final class AndroidRecordNaming
    extends DefaultAccessorNamingStrategy {
        private final Set<String> _componentNames;

        AndroidRecordNaming(MapperConfig<?> config, AnnotatedClass forClass) {
            super(config, forClass, null, "get", "is", null);
            this._componentNames = AndroidRecordModule.getDesugaredRecordComponents(forClass.getRawType()).map(Field::getName).collect(Collectors.toSet());
        }

        public String findNameForRegularGetter(AnnotatedMethod am, String name) {
            if (this._componentNames.contains(name)) {
                return name;
            }
            return super.findNameForRegularGetter(am, name);
        }
    }
}

