/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.annotationsupport;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class IndexedMap<K, V>
extends AbstractMap<K, V> {
    final ArrayList<Map.Entry<K, V>> entries = new ArrayList();
    private final Map.Entry<K, V> nullValue = new AbstractMap.SimpleEntry<Object, Object>(null, null);

    IndexedMap() {
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean containsValue(Object object) {
        return this.entries.stream().anyMatch(entry -> entry.getValue().equals(object));
    }

    @Override
    public V get(Object object) {
        return this.entries.stream().filter(entry -> entry.getKey().equals(object)).findFirst().orElse(this.nullValue).getValue();
    }

    @Override
    public V put(K k, V v) {
        V v2 = this.remove(k);
        this.entries.add(new AbstractMap.SimpleEntry<K, V>(k, v));
        return v2;
    }

    @Override
    public V remove(Object object) {
        V v = null;
        for (int i = 0; i < this.entries.size(); ++i) {
            Map.Entry<K, V> entry = this.entries.get(i);
            if (!entry.getKey().equals(object)) continue;
            v = entry.getValue();
            this.entries.remove(i);
            break;
        }
        return v;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.entries.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new LinkedHashSet<Map.Entry<K, V>>(this.entries);
    }

    public void replaceAtIndexOf(K k, K k2, V v) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Map.Entry<K, V> entry = this.entries.get(i);
            if (!entry.getKey().equals(k)) continue;
            this.entries.set(i, new AbstractMap.SimpleEntry<K, V>(k2, v));
            break;
        }
    }

    final class Values
    extends AbstractList<V> {
        Values() {
        }

        @Override
        public int size() {
            return IndexedMap.this.entries.size();
        }

        @Override
        public boolean contains(Object object) {
            for (Map.Entry entry : IndexedMap.this.entries) {
                if (!entry.getValue().equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                final Iterator<Map.Entry<K, V>> it;
                {
                    this.it = IndexedMap.this.entries.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public V next() {
                    return this.it.next().getValue();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < IndexedMap.this.entries.size(); ++i) {
                objectArray[i] = IndexedMap.this.entries.get(i).getValue();
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < IndexedMap.this.entries.size(); ++i) {
                objectArray[i] = IndexedMap.this.entries.get(i).getValue();
            }
            return objectArray;
        }

        @Override
        public boolean remove(Object object) {
            for (int i = 0; i < IndexedMap.this.entries.size(); ++i) {
                if (!IndexedMap.this.entries.get(i).getValue().equals(object)) continue;
                IndexedMap.this.entries.remove(i);
                return true;
            }
            return false;
        }

        @Override
        public V get(int n) {
            return IndexedMap.this.entries.get(n).getValue();
        }

        @Override
        public void clear() {
            IndexedMap.this.entries.clear();
        }
    }
}

