/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.annotationsupport;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.jr.annotationsupport.AnnotationBasedIntrospector;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.ReaderWriterModifier;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.api.ValueWriter;
import tools.jackson.jr.ob.impl.JSONReader;
import tools.jackson.jr.ob.impl.JSONWriter;
import tools.jackson.jr.ob.impl.POJODefinition;

public class AnnotationBasedValueRWModifier
extends ReaderWriterModifier {
    protected static final int SER_ENUM_ID = 32;
    protected final JsonAutoDetect.Value _visibility;

    public AnnotationBasedValueRWModifier(JsonAutoDetect.Value value) {
        this._visibility = value;
    }

    public POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz) {
        return AnnotationBasedIntrospector.pojoDefinitionForDeserialization(jSONReader, clazz, this._visibility);
    }

    public POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz) {
        return AnnotationBasedIntrospector.pojoDefinitionForSerialization(jSONWriter, clazz, this._visibility);
    }

    public ValueWriter overrideStandardValueWriter(JSONWriter jSONWriter, Class<?> clazz, int n) {
        if (n == 32) {
            EnumJsonValueWriter enumJsonValueWriter = EnumJsonValueWriter.of(clazz);
            if (enumJsonValueWriter != null) {
                return enumJsonValueWriter;
            }
            if (clazz.isEnum()) {
                return new EnumWriter(clazz);
            }
        }
        return null;
    }

    public ValueReader modifyValueReader(JSONReader jSONReader, Class<?> clazz, ValueReader valueReader) {
        EnumJsonCreatorReader enumJsonCreatorReader;
        if (clazz.isEnum() && (enumJsonCreatorReader = EnumJsonCreatorReader.of(clazz)) != null) {
            return enumJsonCreatorReader;
        }
        return super.modifyValueReader(jSONReader, clazz, valueReader);
    }

    private static class EnumJsonValueWriter
    implements ValueWriter {
        private final Class<?> _valueType;
        private final Method _jsonValueMethod;

        private EnumJsonValueWriter(Class<?> clazz, Method method) {
            this._valueType = clazz;
            this._jsonValueMethod = method;
            method.setAccessible(true);
        }

        public void writeValue(JSONWriter jSONWriter, JsonGenerator jsonGenerator, Object object) throws JacksonException {
            Object object2;
            try {
                object2 = this._jsonValueMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new JSONObjectException("Cannot call JsonValue method", (Throwable)exception);
            }
            jSONWriter.writeValue(object2);
        }

        public Class<?> valueType() {
            return this._valueType;
        }

        public static EnumJsonValueWriter of(Class<?> clazz) {
            return EnumJsonValueWriter.getJsonValueFunction(clazz, clazz);
        }

        private static EnumJsonValueWriter getJsonValueFunction(Class<?> clazz, Class<?> clazz2) {
            EnumJsonValueWriter enumJsonValueWriter;
            for (Method method : clazz2.getDeclaredMethods()) {
                JsonValue jsonValue = method.getDeclaredAnnotation(JsonValue.class);
                if (Modifier.isStatic(method.getModifiers()) || jsonValue == null || method.getParameterCount() != 0 || !method.getReturnType().equals(String.class)) continue;
                if (jsonValue.value()) {
                    return new EnumJsonValueWriter(clazz, method);
                }
                return null;
            }
            Class<?> clazz3 = clazz2.getSuperclass();
            if (clazz3 != null && (enumJsonValueWriter = EnumJsonValueWriter.getJsonValueFunction(clazz, clazz3)) != null) {
                return enumJsonValueWriter;
            }
            for (Class<?> clazz4 : clazz2.getInterfaces()) {
                EnumJsonValueWriter enumJsonValueWriter2 = EnumJsonValueWriter.getJsonValueFunction(clazz, clazz4);
                if (enumJsonValueWriter2 == null) continue;
                return enumJsonValueWriter2;
            }
            return null;
        }
    }

    private static class EnumWriter
    implements ValueWriter {
        private final Class<?> _valueType;
        private final Map<String, String> enumMap;

        public EnumWriter(Class<?> clazz) {
            Field[] fieldArray;
            this._valueType = clazz;
            this.enumMap = new HashMap<String, String>();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(JsonProperty.class)) {
                    this.enumMap.put(field.getName(), field.getAnnotation(JsonProperty.class).value());
                    continue;
                }
                this.enumMap.put(field.getName(), field.getName());
            }
        }

        public void writeValue(JSONWriter jSONWriter, JsonGenerator jsonGenerator, Object object) throws JacksonException {
            jSONWriter.writeValue((Object)this.enumMap.get(((Enum)object).name()));
        }

        public Class<?> valueType() {
            return this._valueType;
        }
    }

    private static class EnumJsonCreatorReader
    extends ValueReader {
        private final Method _jsonCreatorMethod;

        private EnumJsonCreatorReader(Class<?> clazz, Method method) {
            super(clazz);
            this._jsonCreatorMethod = method;
            method.setAccessible(true);
        }

        public Object read(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
            try {
                return this._jsonCreatorMethod.invoke((Object)this._valueType, jsonParser.getString());
            }
            catch (Exception exception) {
                throw new JSONObjectException("Cannot call JsonCreator method", (Throwable)exception);
            }
        }

        public static EnumJsonCreatorReader of(Class<?> clazz) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || method.getDeclaredAnnotation(JsonCreator.class) == null || method.getParameterCount() != 1 || !method.getReturnType().equals(clazz)) continue;
                return new EnumJsonCreatorReader(clazz, method);
            }
            return null;
        }
    }
}

