/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.ser;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.GeneratorSettings;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.ser.SerializationContextExt;
import tools.jackson.databind.ser.SerializerCache;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.util.TokenBuffer;
import tools.jackson.dataformat.xml.XmlWriteFeature;
import tools.jackson.dataformat.xml.ser.ToXmlGenerator;
import tools.jackson.dataformat.xml.util.StaxUtil;
import tools.jackson.dataformat.xml.util.TypeUtil;
import tools.jackson.dataformat.xml.util.XmlRootNameLookup;

public class XmlSerializationContext
extends SerializationContextExt {
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializationContext(TokenStreamFactory streamFactory, SerializationConfig config, GeneratorSettings genSettings, SerializerFactory f, SerializerCache cache, XmlRootNameLookup rootLookup) {
        super(streamFactory, config, genSettings, f, cache);
        this._rootNameLookup = rootLookup;
    }

    public void serializeValue(JsonGenerator gen, Object value) throws JacksonException {
        boolean asArray;
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        Class<?> cls = value.getClass();
        ToXmlGenerator xgen = this._asXmlGenerator(gen);
        if (xgen == null) {
            asArray = false;
        } else {
            if (this._shouldUnwrapObjectNode(xgen, value)) {
                this._serializeUnwrappedObjectNode(xgen, value, null);
                return;
            }
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName((DatabindContext)this, cls);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(this._config.constructType(cls));
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        ValueSerializer ser = this.findTypedValueSerializer(cls, true);
        try {
            ser.serialize(value, gen, (SerializationContext)this);
        }
        catch (Exception e) {
            throw this._wrapAsJacksonE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType) throws JacksonException {
        this.serializeValue(gen, value, rootType, null);
    }

    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType, ValueSerializer<Object> ser) throws JacksonException {
        boolean asArray;
        ToXmlGenerator xgen;
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        if ((xgen = this._asXmlGenerator(gen)) == null) {
            asArray = false;
        } else {
            if (this._shouldUnwrapObjectNode(xgen, value)) {
                this._serializeUnwrappedObjectNode(xgen, value, (ValueSerializer<Object>)ser);
                return;
            }
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = rootType == null ? this._rootNameLookup.findRootName((DatabindContext)this, value.getClass()) : this._rootNameLookup.findRootName((DatabindContext)this, rootType);
            }
            this._initWithRootName(xgen, rootName);
            boolean bl = asArray = rootType == null ? TypeUtil.isIndexedType(this._config.constructType(value.getClass())) : TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        if (ser == null) {
            ser = this.findTypedValueSerializer(rootType, true);
        }
        try {
            ser.serialize(value, gen, (SerializationContext)this);
        }
        catch (Exception e) {
            throw this._wrapAsJacksonE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    public void serializePolymorphic(JsonGenerator gen, Object value, JavaType rootType, ValueSerializer<Object> valueSer, TypeSerializer typeSer) throws JacksonException {
        boolean asArray;
        ToXmlGenerator xgen;
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        if ((xgen = this._asXmlGenerator(gen)) == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = rootType == null ? this._rootNameLookup.findRootName((DatabindContext)this, value.getClass()) : this._rootNameLookup.findRootName((DatabindContext)this, rootType);
            }
            this._initWithRootName(xgen, rootName);
            boolean bl = asArray = rootType == null ? TypeUtil.isIndexedType(this._config.constructType(value.getClass())) : TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        if (valueSer == null) {
            valueSer = rootType != null && rootType.isContainerType() ? this.handleRootContextualization(this.findValueSerializer(rootType)) : this.handleRootContextualization(this.findValueSerializer(value.getClass()));
        }
        try {
            valueSer.serializeWithType(value, gen, (SerializationContext)this, typeSer);
        }
        catch (Exception e) {
            throw this._wrapAsJacksonE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator gen) throws JacksonException {
        QName rootName = this._rootNameFromConfig();
        if (rootName == null) {
            rootName = XmlRootNameLookup.ROOT_NAME_FOR_NULL;
        }
        if (gen instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)gen, rootName);
        }
        super.serializeValue(gen, null);
    }

    protected void _startRootArray(ToXmlGenerator xgen, QName rootName) throws JacksonException {
        xgen.writeStartObject();
        xgen.writeName("item");
    }

    protected void _initWithRootName(ToXmlGenerator xgen, QName rootName) throws JacksonException {
        if (!xgen.setNextNameIfMissing(rootName) && xgen.inRoot()) {
            xgen.setNextName(rootName);
        }
        xgen.initGenerator();
        String ns = rootName.getNamespaceURI();
        if (ns != null && ns.length() > 0) {
            try {
                xgen.getStaxWriter().setDefaultNamespace(ns);
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsWriteException(e, (JsonGenerator)xgen);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        PropertyName name = this._config.getFullRootName();
        if (name == null) {
            return null;
        }
        String ns = name.getNamespace();
        if (ns == null || ns.isEmpty()) {
            return new QName(name.getSimpleName());
        }
        return new QName(ns, name.getSimpleName());
    }

    protected boolean _shouldUnwrapObjectNode(ToXmlGenerator xgen, Object value) {
        return xgen.isEnabled(XmlWriteFeature.UNWRAP_ROOT_OBJECT_NODE) && value instanceof ObjectNode && ((ObjectNode)value).size() == 1;
    }

    protected void _serializeUnwrappedObjectNode(ToXmlGenerator xgen, Object value, ValueSerializer<Object> ser) throws JacksonException {
        ObjectNode root = (ObjectNode)value;
        Map.Entry entry = (Map.Entry)root.properties().iterator().next();
        JsonNode newRoot = (JsonNode)entry.getValue();
        this._initWithRootName(xgen, new QName((String)entry.getKey()));
        if (ser == null) {
            ser = this.findTypedValueSerializer(newRoot.getClass(), true);
        }
        ser.serialize((Object)newRoot, (JsonGenerator)xgen, (SerializationContext)this);
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator gen) {
        if (!(gen instanceof ToXmlGenerator)) {
            if (gen instanceof TokenBuffer) {
                return null;
            }
            throw DatabindException.from((JsonGenerator)gen, (String)("XmlMapper does not work with generators of type other than `ToXmlGenerator`; got: `" + gen.getClass().getName() + "`"));
        }
        return (ToXmlGenerator)gen;
    }

    protected JacksonException _wrapAsJacksonE(JsonGenerator g, Exception e) {
        if (e instanceof IOException) {
            return JacksonIOException.construct((IOException)((IOException)e));
        }
        if (e instanceof DatabindException) {
            throw (DatabindException)e;
        }
        Object msg = e.getMessage();
        if (msg == null) {
            msg = "[no message for " + e.getClass().getName() + "]";
        }
        return DatabindException.from((JsonGenerator)g, (String)msg, (Throwable)e);
    }
}

