/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.ser;

import java.io.Serializable;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.bean.BeanSerializerBase;
import tools.jackson.dataformat.xml.ser.XmlBeanPropertyWriter;
import tools.jackson.dataformat.xml.ser.XmlBeanSerializer;
import tools.jackson.dataformat.xml.ser.XmlBeanSerializerBase;
import tools.jackson.dataformat.xml.util.AnnotationUtil;
import tools.jackson.dataformat.xml.util.TypeUtil;
import tools.jackson.dataformat.xml.util.XmlInfo;

public class XmlBeanSerializerModifier
extends ValueSerializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int len = beanProperties.size();
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = beanProperties.get(i);
            AnnotatedMember member = bpw.getMember();
            String ns = AnnotationUtil.findNamespaceAnnotation(config, intr, member);
            Boolean isAttribute = AnnotationUtil.findIsAttributeAnnotation(config, intr, member);
            Boolean isText = AnnotationUtil.findIsTextAnnotation(config, intr, member);
            Boolean isCData = AnnotationUtil.findIsCDataAnnotation(config, intr, member);
            bpw.setInternalSetting((Object)XmlBeanSerializerBase.KEY_XML_INFO, (Object)new XmlInfo(isAttribute, ns, isText, isCData));
            if (!TypeUtil.isIndexedType(bpw.getType())) continue;
            PropertyName wrappedName = PropertyName.construct((String)bpw.getName(), (String)ns);
            PropertyName wrapperName = bpw.getWrapperName();
            if (wrapperName == null || wrapperName == PropertyName.NO_NAME) continue;
            String localName = wrapperName.getSimpleName();
            if (localName == null || localName.length() == 0) {
                wrapperName = wrappedName;
            }
            beanProperties.set(i, new XmlBeanPropertyWriter(bpw, wrapperName, wrappedName));
        }
        return beanProperties;
    }

    public ValueSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, ValueSerializer<?> serializer) {
        if (!(serializer instanceof BeanSerializerBase)) {
            return serializer;
        }
        return new XmlBeanSerializer((BeanSerializerBase)serializer);
    }
}

